<?php $__env->startSection('title', 'إدارة العملات'); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid">
    <div class="card">
        <div class="card-header d-flex justify-content-between align-items-center">
            <h5 class="mb-0">قائمة العملات</h5>
            <button type="button" class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#addCurrencyModal">
                <i class="bi bi-plus-lg"></i> إضافة عملة جديدة
            </button>
        </div>
        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-hover">
                    <thead>
                        <tr>
                            <th>#</th>
                            <th>الرمز</th>
                            <th>الاسم</th>
                            <th>الرمز المختصر</th>
                            <th>العملة الأساسية</th>
                            <th>الحالة</th>
                            <th>الإجراءات</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php if(isset($currencies) && count($currencies) > 0): ?>
                            <?php $__currentLoopData = $currencies; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $currency): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td><?php echo e($loop->iteration); ?></td>
                                    <td><?php echo e($currency->code); ?></td>
                                    <td><?php echo e($currency->name); ?></td>
                                    <td><?php echo e($currency->symbol); ?></td>
                                    <td>
                                        <?php if($currency->is_base_currency): ?>
                                            <span class="badge bg-success">نعم</span>
                                        <?php else: ?>
                                            <span class="badge bg-secondary">لا</span>
                                        <?php endif; ?>
                                    </td>
                                    <td>
                                        <?php if($currency->is_active): ?>
                                            <span class="badge bg-success">نشط</span>
                                        <?php else: ?>
                                            <span class="badge bg-danger">غير نشط</span>
                                        <?php endif; ?>
                                    </td>
                                    <td>
                                        <div class="btn-group" role="group">
                                            <button type="button" class="btn btn-sm btn-info" data-bs-toggle="modal" data-bs-target="#editCurrencyModal<?php echo e($currency->id); ?>">
                                                <i class="bi bi-pencil"></i>
                                            </button>
                                            <button type="button" class="btn btn-sm btn-danger" data-bs-toggle="modal" data-bs-target="#deleteCurrencyModal<?php echo e($currency->id); ?>">
                                                <i class="bi bi-trash"></i>
                                            </button>
                                        </div>
                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <?php else: ?>
                            <tr>
                                <td colspan="7" class="text-center">لا توجد عملات مسجلة</td>
                            </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>

<!-- نافذة إضافة عملة جديدة -->
<div class="modal fade" id="addCurrencyModal" tabindex="-1" aria-labelledby="addCurrencyModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <form action="<?php echo e(route('currencies.store')); ?>" method="POST">
                <?php echo csrf_field(); ?>
                <div class="modal-header">
                    <h5 class="modal-title" id="addCurrencyModalLabel">إضافة عملة جديدة</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="إغلاق"></button>
                </div>
                <div class="modal-body">
                    <div class="mb-3">
                        <label for="code" class="form-label">رمز العملة <span class="text-danger">*</span></label>
                        <input type="text" class="form-control" id="code" name="code" required maxlength="3" placeholder="مثال: USD">
                        <div class="form-text">يجب أن يكون الرمز 3 أحرف فقط</div>
                    </div>
                    <div class="mb-3">
                        <label for="name" class="form-label">اسم العملة <span class="text-danger">*</span></label>
                        <input type="text" class="form-control" id="name" name="name" required placeholder="مثال: دولار أمريكي">
                    </div>
                    <div class="mb-3">
                        <label for="symbol" class="form-label">الرمز المختصر</label>
                        <input type="text" class="form-control" id="symbol" name="symbol" placeholder="مثال: $">
                    </div>
                    <div class="mb-3 form-check">
                        <input type="checkbox" class="form-check-input" id="is_base_currency" name="is_base_currency">
                        <label class="form-check-label" for="is_base_currency">العملة الأساسية للنظام</label>
                    </div>
                    <div class="mb-3 form-check">
                        <input type="checkbox" class="form-check-input" id="is_active" name="is_active" checked>
                        <label class="form-check-label" for="is_active">نشط</label>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">إلغاء</button>
                    <button type="submit" class="btn btn-primary">حفظ</button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- نوافذ تعديل وحذف العملات (ستتم إضافتها ديناميكيًا لكل عملة) -->
<?php if(isset($currencies)): ?>
    <?php $__currentLoopData = $currencies; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $currency): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <!-- نافذة تعديل العملة -->
        <div class="modal fade" id="editCurrencyModal<?php echo e($currency->id); ?>" tabindex="-1" aria-labelledby="editCurrencyModalLabel<?php echo e($currency->id); ?>" aria-hidden="true">
            <div class="modal-dialog">
                <div class="modal-content">
                    <form action="<?php echo e(route('currencies.update', $currency->id)); ?>" method="POST">
                        <?php echo csrf_field(); ?>
                        <?php echo method_field('PUT'); ?>
                        <div class="modal-header">
                            <h5 class="modal-title" id="editCurrencyModalLabel<?php echo e($currency->id); ?>">تعديل العملة</h5>
                            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="إغلاق"></button>
                        </div>
                        <div class="modal-body">
                            <div class="mb-3">
                                <label for="edit_code<?php echo e($currency->id); ?>" class="form-label">رمز العملة <span class="text-danger">*</span></label>
                                <input type="text" class="form-control" id="edit_code<?php echo e($currency->id); ?>" name="code" required maxlength="3" value="<?php echo e($currency->code); ?>">
                            </div>
                            <div class="mb-3">
                                <label for="edit_name<?php echo e($currency->id); ?>" class="form-label">اسم العملة <span class="text-danger">*</span></label>
                                <input type="text" class="form-control" id="edit_name<?php echo e($currency->id); ?>" name="name" required value="<?php echo e($currency->name); ?>">
                            </div>
                            <div class="mb-3">
                                <label for="edit_symbol<?php echo e($currency->id); ?>" class="form-label">الرمز المختصر</label>
                                <input type="text" class="form-control" id="edit_symbol<?php echo e($currency->id); ?>" name="symbol" value="<?php echo e($currency->symbol); ?>">
                            </div>
                            <div class="mb-3 form-check">
                                <input type="checkbox" class="form-check-input" id="edit_is_base_currency<?php echo e($currency->id); ?>" name="is_base_currency" <?php echo e($currency->is_base_currency ? 'checked' : ''); ?>>
                                <label class="form-check-label" for="edit_is_base_currency<?php echo e($currency->id); ?>">العملة الأساسية للنظام</label>
                            </div>
                            <div class="mb-3 form-check">
                                <input type="checkbox" class="form-check-input" id="edit_is_active<?php echo e($currency->id); ?>" name="is_active" <?php echo e($currency->is_active ? 'checked' : ''); ?>>
                                <label class="form-check-label" for="edit_is_active<?php echo e($currency->id); ?>">نشط</label>
                            </div>
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">إلغاء</button>
                            <button type="submit" class="btn btn-primary">حفظ التغييرات</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>

        <!-- نافذة حذف العملة -->
        <div class="modal fade" id="deleteCurrencyModal<?php echo e($currency->id); ?>" tabindex="-1" aria-labelledby="deleteCurrencyModalLabel<?php echo e($currency->id); ?>" aria-hidden="true">
            <div class="modal-dialog">
                <div class="modal-content">
                    <form action="<?php echo e(route('currencies.destroy', $currency->id)); ?>" method="POST">
                        <?php echo csrf_field(); ?>
                        <?php echo method_field('DELETE'); ?>
                        <div class="modal-header">
                            <h5 class="modal-title" id="deleteCurrencyModalLabel<?php echo e($currency->id); ?>">تأكيد الحذف</h5>
                            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="إغلاق"></button>
                        </div>
                        <div class="modal-body">
                            <p>هل أنت متأكد من حذف العملة "<?php echo e($currency->name); ?> (<?php echo e($currency->code); ?>)"؟</p>
                            <div class="alert alert-warning">
                                <i class="bi bi-exclamation-triangle"></i>
                                تحذير: سيؤدي حذف هذه العملة إلى حذف جميع أسعار الصرف المرتبطة بها.
                            </div>
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">إلغاء</button>
                            <button type="submit" class="btn btn-danger">تأكيد الحذف</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
<?php endif; ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\laragon\www\currencyexchangec\resources\views/currencies/index.blade.php ENDPATH**/ ?>