<?php $__env->startSection('title', 'التقارير والإحصائيات'); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid">
    <!-- بطاقات التقارير الرئيسية -->
    <div class="row">
        <div class="col-md-3 mb-4">
            <div class="card h-100">
                <div class="card-body text-center">
                    <i class="bi bi-currency-exchange text-primary" style="font-size: 2.5rem;"></i>
                    <h5 class="card-title mt-3">تقرير المعاملات</h5>
                    <p class="card-text">عرض وتحليل جميع المعاملات المالية في النظام</p>
                    <button type="button" class="btn btn-primary w-100" data-bs-toggle="modal" data-bs-target="#transactionsReportModal">
                        عرض التقرير
                    </button>
                </div>
            </div>
        </div>
        <div class="col-md-3 mb-4">
            <div class="card h-100">
                <div class="card-body text-center">
                    <i class="bi bi-send text-success" style="font-size: 2.5rem;"></i>
                    <h5 class="card-title mt-3">تقرير الحوالات</h5>
                    <p class="card-text">عرض وتحليل جميع الحوالات المالية في النظام</p>
                    <button type="button" class="btn btn-success w-100" data-bs-toggle="modal" data-bs-target="#remittancesReportModal">
                        عرض التقرير
                    </button>
                </div>
            </div>
        </div>
        <div class="col-md-3 mb-4">
            <div class="card h-100">
                <div class="card-body text-center">
                    <i class="bi bi-cash-coin text-info" style="font-size: 2.5rem;"></i>
                    <h5 class="card-title mt-3">تقرير أسعار الصرف</h5>
                    <p class="card-text">عرض وتحليل أسعار صرف العملات في النظام</p>
                    <button type="button" class="btn btn-info w-100" data-bs-toggle="modal" data-bs-target="#exchangeRatesReportModal">
                        عرض التقرير
                    </button>
                </div>
            </div>
        </div>
        <div class="col-md-3 mb-4">
            <div class="card h-100">
                <div class="card-body text-center">
                    <i class="bi bi-bar-chart text-warning" style="font-size: 2.5rem;"></i>
                    <h5 class="card-title mt-3">التقرير المالي</h5>
                    <p class="card-text">عرض وتحليل الأرباح والمصروفات والإيرادات</p>
                    <button type="button" class="btn btn-warning w-100" data-bs-toggle="modal" data-bs-target="#financialReportModal">
                        عرض التقرير
                    </button>
                </div>
            </div>
        </div>
    </div>

    <!-- لوحة الإحصائيات -->
    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h5 class="mb-0">الإحصائيات العامة</h5>
                    <div class="btn-group" role="group">
                        <button type="button" class="btn btn-sm btn-outline-secondary active" id="statsDaily">يومي</button>
                        <button type="button" class="btn btn-sm btn-outline-secondary" id="statsWeekly">أسبوعي</button>
                        <button type="button" class="btn btn-sm btn-outline-secondary" id="statsMonthly">شهري</button>
                        <button type="button" class="btn btn-sm btn-outline-secondary" id="statsYearly">سنوي</button>
                    </div>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-8">
                            <canvas id="statsChart" height="300"></canvas>
                        </div>
                        <div class="col-md-4">
                            <h6 class="border-bottom pb-2 mb-3">ملخص الإحصائيات</h6>
                            <div class="mb-3">
                                <div class="d-flex justify-content-between mb-1">
                                    <span>إجمالي المعاملات:</span>
                                    <span class="fw-bold"><?php echo e(isset($stats['transactions_count']) ? number_format($stats['transactions_count']) : '0'); ?></span>
                                </div>
                                <div class="progress" style="height: 5px;">
                                    <div class="progress-bar bg-primary" role="progressbar" style="width: 100%"></div>
                                </div>
                            </div>
                            <div class="mb-3">
                                <div class="d-flex justify-content-between mb-1">
                                    <span>إجمالي الحوالات:</span>
                                    <span class="fw-bold"><?php echo e(isset($stats['remittances_count']) ? number_format($stats['remittances_count']) : '0'); ?></span>
                                </div>
                                <div class="progress" style="height: 5px;">
                                    <div class="progress-bar bg-success" role="progressbar" style="width: 100%"></div>
                                </div>
                            </div>
                            <div class="mb-3">
                                <div class="d-flex justify-content-between mb-1">
                                    <span>إجمالي العملاء:</span>
                                    <span class="fw-bold"><?php echo e(isset($stats['customers_count']) ? number_format($stats['customers_count']) : '0'); ?></span>
                                </div>
                                <div class="progress" style="height: 5px;">
                                    <div class="progress-bar bg-info" role="progressbar" style="width: 100%"></div>
                                </div>
                            </div>
                            <div class="mb-3">
                                <div class="d-flex justify-content-between mb-1">
                                    <span>إجمالي الإيرادات:</span>
                                    <span class="fw-bold"><?php echo e(isset($stats['total_revenue']) ? number_format($stats['total_revenue'], 2) : '0.00'); ?></span>
                                </div>
                                <div class="progress" style="height: 5px;">
                                    <div class="progress-bar bg-warning" role="progressbar" style="width: 100%"></div>
                                </div>
                            </div>
                            <div class="mb-3">
                                <div class="d-flex justify-content-between mb-1">
                                    <span>إجمالي العمولات:</span>
                                    <span class="fw-bold"><?php echo e(isset($stats['total_commission']) ? number_format($stats['total_commission'], 2) : '0.00'); ?></span>
                                </div>
                                <div class="progress" style="height: 5px;">
                                    <div class="progress-bar bg-danger" role="progressbar" style="width: 100%"></div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- أكثر العملات تداولاً -->
    <div class="row mt-4">
        <div class="col-md-6">
            <div class="card">
                <div class="card-header">
                    <h5 class="mb-0">أكثر العملات تداولاً</h5>
                </div>
                <div class="card-body">
                    <canvas id="topCurrenciesChart" height="300"></canvas>
                </div>
            </div>
        </div>
        <div class="col-md-6">
            <div class="card">
                <div class="card-header">
                    <h5 class="mb-0">توزيع الحوالات حسب الدول</h5>
                </div>
                <div class="card-body">
                    <canvas id="remittancesByCountryChart" height="300"></canvas>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- نافذة تقرير المعاملات -->
<div class="modal fade" id="transactionsReportModal" tabindex="-1" aria-labelledby="transactionsReportModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-xl">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="transactionsReportModalLabel">تقرير المعاملات</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="إغلاق"></button>
            </div>
            <div class="modal-body">
                <!-- فلاتر البحث -->
                <div class="row mb-3">
                    <div class="col-md-12">
                        <form id="transactionsReportForm" class="row g-3">
                            <div class="col-md-3">
                                <label for="from_date" class="form-label">من تاريخ</label>
                                <input type="date" class="form-control" id="from_date" name="from_date">
                            </div>
                            <div class="col-md-3">
                                <label for="to_date" class="form-label">إلى تاريخ</label>
                                <input type="date" class="form-control" id="to_date" name="to_date">
                            </div>
                            <div class="col-md-3">
                                <label for="currency_id" class="form-label">العملة</label>
                                <select class="form-select" id="currency_id" name="currency_id">
                                    <option value="">جميع العملات</option>
                                    <?php if(isset($currencies)): ?>
                                        <?php $__currentLoopData = $currencies; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $currency): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($currency->id); ?>"><?php echo e($currency->code); ?> - <?php echo e($currency->name); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    <?php endif; ?>
                                </select>
                            </div>
                            <div class="col-md-3">
                                <label for="transaction_type" class="form-label">نوع المعاملة</label>
                                <select class="form-select" id="transaction_type" name="transaction_type">
                                    <option value="">جميع المعاملات</option>
                                    <option value="buy">شراء</option>
                                    <option value="sell">بيع</option>
                                </select>
                            </div>
                            <div class="col-md-12 text-center mt-3">
                                <button type="submit" class="btn btn-primary">
                                    <i class="bi bi-search"></i> عرض التقرير
                                </button>
                                <button type="button" class="btn btn-success ms-2" id="exportTransactionsReport">
                                    <i class="bi bi-file-excel"></i> تصدير إلى Excel
                                </button>
                                <button type="button" class="btn btn-danger ms-2" id="printTransactionsReport">
                                    <i class="bi bi-printer"></i> طباعة التقرير
                                </button>
                            </div>
                        </form>
                    </div>
                </div>

                <!-- نتائج التقرير -->
                <div id="transactionsReportResults">
                    <div class="table-responsive">
                        <table class="table table-bordered table-hover">
                            <thead>
                                <tr>
                                    <th>رقم المعاملة</th>
                                    <th>التاريخ</th>
                                    <th>العميل</th>
                                    <th>نوع المعاملة</th>
                                    <th>من العملة</th>
                                    <th>المبلغ</th>
                                    <th>إلى العملة</th>
                                    <th>المبلغ</th>
                                    <th>سعر الصرف</th>
                                    <th>العمولة</th>
                                    <th>الحالة</th>
                                </tr>
                            </thead>
                            <tbody>
                                <!-- ستتم تعبئة البيانات هنا عند تقديم نموذج التقرير -->
                                <tr>
                                    <td colspan="11" class="text-center">يرجى تحديد معايير البحث وعرض التقرير</td>
                                </tr>
                            </tbody>
                            <tfoot>
                                <tr class="table-dark">
                                    <th colspan="5">الإجمالي</th>
                                    <th id="totalFromAmount">0.00</th>
                                    <th></th>
                                    <th id="totalToAmount">0.00</th>
                                    <th></th>
                                    <th id="totalCommission">0.00</th>
                                    <th></th>
                                </tr>
                            </tfoot>
                        </table>
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">إغلاق</button>
            </div>
        </div>
    </div>
</div>

<!-- نافذة تقرير الحوالات -->
<div class="modal fade" id="remittancesReportModal" tabindex="-1" aria-labelledby="remittancesReportModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-xl">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="remittancesReportModalLabel">تقرير الحوالات</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="إغلاق"></button>
            </div>
            <div class="modal-body">
                <!-- فلاتر البحث -->
                <div class="row mb-3">
                    <div class="col-md-12">
                        <form id="remittancesReportForm" class="row g-3">
                            <div class="col-md-2">
                                <label for="remittance_from_date" class="form-label">من تاريخ</label>
                                <input type="date" class="form-control" id="remittance_from_date" name="from_date">
                            </div>
                            <div class="col-md-2">
                                <label for="remittance_to_date" class="form-label">إلى تاريخ</label>
                                <input type="date" class="form-control" id="remittance_to_date" name="to_date">
                            </div>
                            <div class="col-md-2">
                                <label for="remittance_currency_id" class="form-label">العملة</label>
                                <select class="form-select" id="remittance_currency_id" name="currency_id">
                                    <option value="">جميع العملات</option>
                                    <?php if(isset($currencies)): ?>
                                        <?php $__currentLoopData = $currencies; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $currency): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($currency->id); ?>"><?php echo e($currency->code); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    <?php endif; ?>
                                </select>
                            </div>
                            <div class="col-md-2">
                                <label for="remittance_status" class="form-label">الحالة</label>
                                <select class="form-select" id="remittance_status" name="status">
                                    <option value="">جميع الحالات</option>
                                    <option value="pending">معلقة</option>
                                    <option value="sent">مرسلة</option>
                                    <option value="received">مستلمة</option>
                                    <option value="cancelled">ملغاة</option>
                                </select>
                            </div>
                            <div class="col-md-2">
                                <label for="sender_name" class="form-label">اسم المرسل</label>
                                <input type="text" class="form-control" id="sender_name" name="sender_name">
                            </div>
                            <div class="col-md-2">
                                <label for="receiver_name" class="form-label">اسم المستلم</label>
                                <input type="text" class="form-control" id="receiver_name" name="receiver_name">
                            </div>
                            <div class="col-md-12 text-center mt-3">
                                <button type="submit" class="btn btn-primary">
                                    <i class="bi bi-search"></i> عرض التقرير
                                </button>
                                <button type="button" class="btn btn-success ms-2" id="exportRemittancesReport">
                                    <i class="bi bi-file-excel"></i> تصدير إلى Excel
                                </button>
                                <button type="button" class="btn btn-danger ms-2" id="printRemittancesReport">
                                    <i class="bi bi-printer"></i> طباعة التقرير
                                </button>
                            </div>
                        </form>
                    </div>
                </div>

                <!-- نتائج التقرير -->
                <div id="remittancesReportResults">
                    <div class="table-responsive">
                        <table class="table table-bordered table-hover">
                            <thead>
                                <tr>
                                    <th>رقم الحوالة</th>
                                    <th>تاريخ الإرسال</th>
                                    <th>المرسل</th>
                                    <th>المستلم</th>
                                    <th>من العملة</th>
                                    <th>المبلغ المرسل</th>
                                    <th>إلى العملة</th>
                                    <th>المبلغ المستلم</th>
                                    <th>العمولة</th>
                                    <th>الحالة</th>
                                    <th>تاريخ الاستلام</th>
                                </tr>
                            </thead>
                            <tbody>
                                <!-- ستتم تعبئة البيانات هنا عند تقديم نموذج التقرير -->
                                <tr>
                                    <td colspan="11" class="text-center">يرجى تحديد معايير البحث وعرض التقرير</td>
                                </tr>
                            </tbody>
                            <tfoot>
                                <tr class="table-dark">
                                    <th colspan="5">الإجمالي</th>
                                    <th id="totalRemittanceFromAmount">0.00</th>
                                    <th></th>
                                    <th id="totalRemittanceToAmount">0.00</th>
                                    <th id="totalRemittanceCommission">0.00</th>
                                    <th colspan="2"></th>
                                </tr>
                            </tfoot>
                        </table>
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">إغلاق</button>
            </div>
        </div>
    </div>
</div>

<!-- نافذة تقرير أسعار الصرف -->
<div class="modal fade" id="exchangeRatesReportModal" tabindex="-1" aria-labelledby="exchangeRatesReportModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="exchangeRatesReportModalLabel">تقرير أسعار الصرف</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="إغلاق"></button>
            </div>
            <div class="modal-body">
                <!-- فلاتر البحث -->
                <div class="row mb-3">
                    <div class="col-md-12">
                        <form id="exchangeRatesReportForm" class="row g-3">
                            <div class="col-md-4">
                                <label for="from_currency_id" class="form-label">من العملة</label>
                                <select class="form-select" id="from_currency_id" name="from_currency_id">
                                    <option value="">جميع العملات</option>
                                    <?php if(isset($currencies)): ?>
                                        <?php $__currentLoopData = $currencies; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $currency): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($currency->id); ?>"><?php echo e($currency->code); ?> - <?php echo e($currency->name); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    <?php endif; ?>
                                </select>
                            </div>
                            <div class="col-md-4">
                                <label for="to_currency_id" class="form-label">إلى العملة</label>
                                <select class="form-select" id="to_currency_id" name="to_currency_id">
                                    <option value="">جميع العملات</option>
                                    <?php if(isset($currencies)): ?>
                                        <?php $__currentLoopData = $currencies; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $currency): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($currency->id); ?>"><?php echo e($currency->code); ?> - <?php echo e($currency->name); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    <?php endif; ?>
                                </select>
                            </div>
                            <div class="col-md-4">
                                <label for="date_range" class="form-label">نطاق التاريخ</label>
                                <select class="form-select" id="date_range" name="date_range">
                                    <option value="today">اليوم</option>
                                    <option value="yesterday">الأمس</option>
                                    <option value="last_7_days">آخر 7 أيام</option>
                                    <option value="last_30_days">آخر 30 يوم</option>
                                    <option value="this_month">هذا الشهر</option>
                                    <option value="last_month">الشهر الماضي</option>
                                    <option value="custom">مخصص</option>
                                </select>
                            </div>
                            <div class="col-md-6 custom-date-range d-none">
                                <label for="rate_from_date" class="form-label">من تاريخ</label>
                                <input type="date" class="form-control" id="rate_from_date" name="from_date">
                            </div>
                            <div class="col-md-6 custom-date-range d-none">
                                <label for="rate_to_date" class="form-label">إلى تاريخ</label>
                                <input type="date" class="form-control" id="rate_to_date" name="to_date">
                            </div>
                            <div class="col-md-12 text-center mt-3">
                                <button type="submit" class="btn btn-primary">
                                    <i class="bi bi-search"></i> عرض التقرير
                                </button>
                                <button type="button" class="btn btn-success ms-2" id="exportExchangeRatesReport">
                                    <i class="bi bi-file-excel"></i> تصدير إلى Excel
                                </button>
                                <button type="button" class="btn btn-danger ms-2" id="printExchangeRatesReport">
                                    <i class="bi bi-printer"></i> طباعة التقرير
                                </button>
                            </div>
                        </form>
                    </div>
                </div>

                <!-- نتائج التقرير -->
                <div id="exchangeRatesReportResults">
                    <div class="table-responsive">
                        <table class="table table-bordered table-hover">
                            <thead>
                                <tr>
                                    <th>من العملة</th>
                                    <th>إلى العملة</th>
                                    <th>سعر الشراء</th>
                                    <th>سعر البيع</th>
                                    <th>تاريخ السريان</th>
                                    <th>آخر تحديث</th>
                                </tr>
                            </thead>
                            <tbody>
                                <!-- ستتم تعبئة البيانات هنا عند تقديم نموذج التقرير -->
                                <tr>
                                    <td colspan="6" class="text-center">يرجى تحديد معايير البحث وعرض التقرير</td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                </div>

                <!-- رسم بياني لتغيرات أسعار الصرف -->
                <div class="mt-4">
                    <h6 class="border-bottom pb-2">تغيرات أسعار الصرف</h6>
                    <canvas id="exchangeRatesChart" height="300"></canvas>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">إغلاق</button>
            </div>
        </div>
    </div>
</div>

<!-- نافذة التقرير المالي -->
<div class="modal fade" id="financialReportModal" tabindex="-1" aria-labelledby="financialReportModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="financialReportModalLabel">التقرير المالي</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="إغلاق"></button>
            </div>
            <div class="modal-body">
                <!-- فلاتر البحث -->
                <div class="row mb-3">
                    <div class="col-md-12">
                        <form id="financialReportForm" class="row g-3">
                            <div class="col-md-4">
                                <label for="financial_period" class="form-label">الفترة</label>
                                <select class="form-select" id="financial_period" name="period">
                                    <option value="daily">يومي</option>
                                    <option value="weekly">أسبوعي</option>
                                    <option value="monthly" selected>شهري</option>
                                    <option value="quarterly">ربع سنوي</option>
                                    <option value="yearly">سنوي</option>
                                    <option value="custom">مخصص</option>
                                </select>
                            </div>
                            <div class="col-md-4">
                                <label for="financial_from_date" class="form-label">من تاريخ</label>
                                <input type="date" class="form-control" id="financial_from_date" name="from_date">
                            </div>
                            <div class="col-md-4">
                                <label for="financial_to_date" class="form-label">إلى تاريخ</label>
                                <input type="date" class="form-control" id="financial_to_date" name="to_date">
                            </div>
                            <div class="col-md-12 text-center mt-3">
                                <button type="submit" class="btn btn-primary">
                                    <i class="bi bi-search"></i> عرض التقرير
                                </button>
                                <button type="button" class="btn btn-success ms-2" id="exportFinancialReport">
                                    <i class="bi bi-file-excel"></i> تصدير إلى Excel
                                </button>
                                <button type="button" class="btn btn-danger ms-2" id="printFinancialReport">
                                    <i class="bi bi-printer"></i> طباعة التقرير
                                </button>
                            </div>
                        </form>
                    </div>
                </div>

                <!-- نتائج التقرير -->
                <div id="financialReportResults">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="card mb-3">
                                <div class="card-body">
                                    <h6 class="card-title">ملخص الإيرادات</h6>
                                    <table class="table table-sm">
                                        <tbody>
                                            <tr>
                                                <th>إيرادات المعاملات:</th>
                                                <td id="transactionsRevenue">0.00</td>
                                            </tr>
                                            <tr>
                                                <th>إيرادات الحوالات:</th>
                                                <td id="remittancesRevenue">0.00</td>
                                            </tr>
                                            <tr>
                                                <th>إيرادات أخرى:</th>
                                                <td id="otherRevenue">0.00</td>
                                            </tr>
                                            <tr class="table-active">
                                                <th>إجمالي الإيرادات:</th>
                                                <td id="totalRevenue">0.00</td>
                                            </tr>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                            <div class="card">
                                <div class="card-body">
                                    <h6 class="card-title">ملخص المصروفات</h6>
                                    <table class="table table-sm">
                                        <tbody>
                                            <tr>
                                                <th>مصروفات التشغيل:</th>
                                                <td id="operatingExpenses">0.00</td>
                                            </tr>
                                            <tr>
                                                <th>مصروفات إدارية:</th>
                                                <td id="administrativeExpenses">0.00</td>
                                            </tr>
                                            <tr>
                                                <th>مصروفات أخرى:</th>
                                                <td id="otherExpenses">0.00</td>
                                            </tr>
                                            <tr class="table-active">
                                                <th>إجمالي المصروفات:</th>
                                                <td id="totalExpenses">0.00</td>
                                            </tr>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="card mb-3">
                                <div class="card-body">
                                    <h6 class="card-title">الربح والخسارة</h6>
                                    <table class="table table-sm">
                                        <tbody>
                                            <tr>
                                                <th>إجمالي الإيرادات:</th>
                                                <td id="profitTotalRevenue">0.00</td>
                                            </tr>
                                            <tr>
                                                <th>إجمالي المصروفات:</th>
                                                <td id="profitTotalExpenses">0.00</td>
                                            </tr>
                                            <tr class="table-active">
                                                <th>صافي الربح:</th>
                                                <td id="netProfit">0.00</td>
                                            </tr>
                                            <tr>
                                                <th>هامش الربح:</th>
                                                <td id="profitMargin">0%</td>
                                            </tr>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                            <div class="card">
                                <div class="card-body">
                                    <h6 class="card-title">الرسم البياني</h6>
                                    <canvas id="financialChart" height="200"></canvas>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">إغلاق</button>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
<script>
    document.addEventListener('DOMContentLoaded', function() {
        // رسم بياني للإحصائيات العامة
        const statsCtx = document.getElementById('statsChart').getContext('2d');
        const statsChart = new Chart(statsCtx, {
            type: 'line',
            data: {
                labels: ['يناير', 'فبراير', 'مارس', 'أبريل', 'مايو', 'يونيو', 'يوليو', 'أغسطس', 'سبتمبر', 'أكتوبر', 'نوفمبر', 'ديسمبر'],
                datasets: [{
                    label: 'المعاملات',
                    data: [12, 19, 3, 5, 2, 3, 7, 8, 10, 15, 20, 25],
                    borderColor: '#3490dc',
                    backgroundColor: 'rgba(52, 144, 220, 0.1)',
                    tension: 0.3,
                    fill: true
                }, {
                    label: 'الحوالات',
                    data: [5, 10, 2, 8, 4, 7, 9, 12, 15, 17, 19, 22],
                    borderColor: '#38c172',
                    backgroundColor: 'rgba(56, 193, 114, 0.1)',
                    tension: 0.3,
                    fill: true
                }]
            },
            options: {
                responsive: true,
                plugins: {
                    legend: {
                        position: 'top',
                    },
                    title: {
                        display: true,
                        text: 'إحصائيات المعاملات والحوالات'
                    }
                },
                scales: {
                    y: {
                        beginAtZero: true
                    }
                }
            }
        });

        // رسم بياني للعملات الأكثر تداولاً
        const topCurrenciesCtx = document.getElementById('topCurrenciesChart').getContext('2d');
        const topCurrenciesChart = new Chart(topCurrenciesCtx, {
            type: 'bar',
            data: {
                labels: ['USD', 'EUR', 'GBP', 'SAR', 'AED', 'JPY'],
                datasets: [{
                    label: 'حجم التداول',
                    data: [65, 59, 80, 81, 56, 55],
                    backgroundColor: [
                        'rgba(52, 144, 220, 0.6)',
                        'rgba(56, 193, 114, 0.6)',
                        'rgba(255, 193, 7, 0.6)',
                        'rgba(220, 53, 69, 0.6)',
                        'rgba(23, 162, 184, 0.6)',
                        'rgba(108, 117, 125, 0.6)'
                    ],
                    borderColor: [
                        'rgba(52, 144, 220, 1)',
                        'rgba(56, 193, 114, 1)',
                        'rgba(255, 193, 7, 1)',
                        'rgba(220, 53, 69, 1)',
                        'rgba(23, 162, 184, 1)',
                        'rgba(108, 117, 125, 1)'
                    ],
                    borderWidth: 1
                }]
            },
            options: {
                responsive: true,
                plugins: {
                    legend: {
                        display: false
                    },
                    title: {
                        display: true,
                        text: 'العملات الأكثر تداولاً'
                    }
                },
                scales: {
                    y: {
                        beginAtZero: true
                    }
                }
            }
        });

        // رسم بياني لتوزيع الحوالات حسب الدول
        const remittancesByCountryCtx = document.getElementById('remittancesByCountryChart').getContext('2d');
        const remittancesByCountryChart = new Chart(remittancesByCountryCtx, {
            type: 'doughnut',
            data: {
                labels: ['مصر', 'الأردن', 'لبنان', 'اليمن', 'السودان', 'أخرى'],
                datasets: [{
                    label: 'الحوالات',
                    data: [30, 25, 15, 10, 10, 10],
                    backgroundColor: [
                        'rgba(52, 144, 220, 0.6)',
                        'rgba(56, 193, 114, 0.6)',
                        'rgba(255, 193, 7, 0.6)',
                        'rgba(220, 53, 69, 0.6)',
                        'rgba(23, 162, 184, 0.6)',
                        'rgba(108, 117, 125, 0.6)'
                    ],
                    borderColor: [
                        'rgba(52, 144, 220, 1)',
                        'rgba(56, 193, 114, 1)',
                        'rgba(255, 193, 7, 1)',
                        'rgba(220, 53, 69, 1)',
                        'rgba(23, 162, 184, 1)',
                        'rgba(108, 117, 125, 1)'
                    ],
                    borderWidth: 1
                }]
            },
            options: {
                responsive: true,
                plugins: {
                    legend: {
                        position: 'right',
                    },
                    title: {
                        display: true,
                        text: 'توزيع الحوالات حسب الدول'
                    }
                }
            }
        });

        // تبديل نطاق الإحصائيات
        document.getElementById('statsDaily').addEventListener('click', function() {
            updateStatsChart('daily');
            setActiveButton(this);
        });

        document.getElementById('statsWeekly').addEventListener('click', function() {
            updateStatsChart('weekly');
            setActiveButton(this);
        });

        document.getElementById('statsMonthly').addEventListener('click', function() {
            updateStatsChart('monthly');
            setActiveButton(this);
        });

        document.getElementById('statsYearly').addEventListener('click', function() {
            updateStatsChart('yearly');
            setActiveButton(this);
        });

        function setActiveButton(button) {
            document.querySelectorAll('#statsDaily, #statsWeekly, #statsMonthly, #statsYearly').forEach(btn => {
                btn.classList.remove('active');
            });
            button.classList.add('active');
        }

        function updateStatsChart(period) {
            // هنا سيتم تحديث البيانات بناءً على الفترة المحددة
            // يمكن استخدام طلب AJAX للحصول على البيانات من الخادم
            
            // لأغراض العرض، نستخدم بيانات عشوائية
            let labels = [];
            let transactionsData = [];
            let remittancesData = [];
            
            if (period === 'daily') {
                labels = ['8:00', '10:00', '12:00', '14:00', '16:00', '18:00'];
                transactionsData = [5, 12, 8, 15, 10, 7];
                remittancesData = [3, 8, 5, 10, 7, 4];
            } else if (period === 'weekly') {
                labels = ['الأحد', 'الإثنين', 'الثلاثاء', 'الأربعاء', 'الخميس', 'الجمعة', 'السبت'];
                transactionsData = [12, 19, 3, 5, 2, 3, 7];
                remittancesData = [5, 10, 2, 8, 4, 7, 9];
            } else if (period === 'monthly') {
                labels = ['1', '5', '10', '15', '20', '25', '30'];
                transactionsData = [20, 25, 30, 35, 25, 20, 15];
                remittancesData = [15, 20, 25, 30, 20, 15, 10];
            } else if (period === 'yearly') {
                labels = ['يناير', 'فبراير', 'مارس', 'أبريل', 'مايو', 'يونيو', 'يوليو', 'أغسطس', 'سبتمبر', 'أكتوبر', 'نوفمبر', 'ديسمبر'];
                transactionsData = [12, 19, 3, 5, 2, 3, 7, 8, 10, 15, 20, 25];
                remittancesData = [5, 10, 2, 8, 4, 7, 9, 12, 15, 17, 19, 22];
            }
            
            statsChart.data.labels = labels;
            statsChart.data.datasets[0].data = transactionsData;
            statsChart.data.datasets[1].data = remittancesData;
            statsChart.update();
        }

        // إظهار/إخفاء حقول التاريخ المخصصة في تقرير أسعار الصرف
        document.getElementById('date_range').addEventListener('change', function() {
            const customDateFields = document.querySelectorAll('.custom-date-range');
            if (this.value === 'custom') {
                customDateFields.forEach(field => field.classList.remove('d-none'));
            } else {
                customDateFields.forEach(field => field.classList.add('d-none'));
            }
        });

        // معالجة نماذج التقارير
        document.getElementById('transactionsReportForm').addEventListener('submit', function(e) {
            e.preventDefault();
            // هنا سيتم إرسال طلب AJAX للحصول على بيانات التقرير
            alert('تم إرسال طلب تقرير المعاملات');
        });

        document.getElementById('remittancesReportForm').addEventListener('submit', function(e) {
            e.preventDefault();
            // هنا سيتم إرسال طلب AJAX للحصول على بيانات التقرير
            alert('تم إرسال طلب تقرير الحوالات');
        });

        document.getElementById('exchangeRatesReportForm').addEventListener('submit', function(e) {
            e.preventDefault();
            // هنا سيتم إرسال طلب AJAX للحصول على بيانات التقرير
            alert('تم إرسال طلب تقرير أسعار الصرف');
            
            // عرض رسم بياني لأسعار الصرف
            const exchangeRatesChartCtx = document.getElementById('exchangeRatesChart').getContext('2d');
            new Chart(exchangeRatesChartCtx, {
                type: 'line',
                data: {
                    labels: ['1/1', '2/1', '3/1', '4/1', '5/1', '6/1', '7/1', '8/1', '9/1', '10/1'],
                    datasets: [{
                        label: 'سعر الشراء',
                        data: [3.65, 3.66, 3.67, 3.65, 3.64, 3.63, 3.65, 3.66, 3.67, 3.68],
                        borderColor: '#3490dc',
                        backgroundColor: 'rgba(52, 144, 220, 0.1)',
                        tension: 0.3,
                        fill: false
                    }, {
                        label: 'سعر البيع',
                        data: [3.75, 3.76, 3.77, 3.75, 3.74, 3.73, 3.75, 3.76, 3.77, 3.78],
                        borderColor: '#e3342f',
                        backgroundColor: 'rgba(227, 52, 47, 0.1)',
                        tension: 0.3,
                        fill: false
                    }]
                },
                options: {
                    responsive: true,
                    plugins: {
                        legend: {
                            position: 'top',
                        },
                        title: {
                            display: true,
                            text: 'تغيرات أسعار الصرف'
                        }
                    },
                    scales: {
                        y: {
                            beginAtZero: false
                        }
                    }
                }
            });
        });

        document.getElementById('financialReportForm').addEventListener('submit', function(e) {
            e.preventDefault();
            // هنا سيتم إرسال طلب AJAX للحصول على بيانات التقرير
            alert('تم إرسال طلب التقرير المالي');
            
            // تعبئة بيانات التقرير المالي (بيانات عشوائية للعرض)
            document.getElementById('transactionsRevenue').textContent = '150,000.00';
            document.getElementById('remittancesRevenue').textContent = '75,000.00';
            document.getElementById('otherRevenue').textContent = '25,000.00';
            document.getElementById('totalRevenue').textContent = '250,000.00';
            
            document.getElementById('operatingExpenses').textContent = '80,000.00';
            document.getElementById('administrativeExpenses').textContent = '40,000.00';
            document.getElementById('otherExpenses').textContent = '10,000.00';
            document.getElementById('totalExpenses').textContent = '130,000.00';
            
            document.getElementById('profitTotalRevenue').textContent = '250,000.00';
            document.getElementById('profitTotalExpenses').textContent = '130,000.00';
            document.getElementById('netProfit').textContent = '120,000.00';
            document.getElementById('profitMargin').textContent = '48%';
            
            // رسم بياني للتقرير المالي
            const financialChartCtx = document.getElementById('financialChart').getContext('2d');
            new Chart(financialChartCtx, {
                type: 'bar',
                data: {
                    labels: ['الإيرادات', 'المصروفات', 'صافي الربح'],
                    datasets: [{
                        label: 'المبلغ',
                        data: [250000, 130000, 120000],
                        backgroundColor: [
                            'rgba(56, 193, 114, 0.6)',
                            'rgba(220, 53, 69, 0.6)',
                            'rgba(52, 144, 220, 0.6)'
                        ],
                        borderColor: [
                            'rgba(56, 193, 114, 1)',
                            'rgba(220, 53, 69, 1)',
                            'rgba(52, 144, 220, 1)'
                        ],
                        borderWidth: 1
                    }]
                },
                options: {
                    responsive: true,
                    plugins: {
                        legend: {
                            display: false
                        }
                    },
                    scales: {
                        y: {
                            beginAtZero: true
                        }
                    }
                }
            });
        });

        // أزرار التصدير والطباعة
        document.getElementById('exportTransactionsReport').addEventListener('click', function() {
            alert('جاري تصدير تقرير المعاملات إلى Excel');
        });

        document.getElementById('printTransactionsReport').addEventListener('click', function() {
            alert('جاري طباعة تقرير المعاملات');
        });

        document.getElementById('exportRemittancesReport').addEventListener('click', function() {
            alert('جاري تصدير تقرير الحوالات إلى Excel');
        });

        document.getElementById('printRemittancesReport').addEventListener('click', function() {
            alert('جاري طباعة تقرير الحوالات');
        });

        document.getElementById('exportExchangeRatesReport').addEventListener('click', function() {
            alert('جاري تصدير تقرير أسعار الصرف إلى Excel');
        });

        document.getElementById('printExchangeRatesReport').addEventListener('click', function() {
            alert('جاري طباعة تقرير أسعار الصرف');
        });

        document.getElementById('exportFinancialReport').addEventListener('click', function() {
            alert('جاري تصدير التقرير المالي إلى Excel');
        });

        document.getElementById('printFinancialReport').addEventListener('click', function() {
            alert('جاري طباعة التقرير المالي');
        });
    });
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\laragon\www\currencyexchange\resources\views/reports/index.blade.php ENDPATH**/ ?>