<!DOCTYPE html>

    <html lang="en" dir="" class="">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">

    <title><?php echo e(config('app.name', 'CodePlus')); ?> - نظام الصرافة والحوالات المالية</title>

    <!-- الخطوط -->
    <link rel="stylesheet" href="https://fonts.googleapis.com/css2?family=Tajawal:wght@400;500;700&display=swap">

    <!-- الأنماط -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.0/font/bootstrap-icons.css" rel="stylesheet">
    
    <style>
        :root {
            --primary-color: #3490dc;
            --secondary-color: #38c172;
            --danger-color: #e3342f;
            --dark-color: #343a40;
        }
        
        body {
            font-family: 'Tajawal', sans-serif;
            background-color: #f8f9fa;
        }
        
        .sidebar {
            min-height: 100vh;
            background-color: var(--dark-color);
            color: white;
        }
        
        .sidebar .nav-link {
            color: rgba(255, 255, 255, 0.8);
            padding: 0.5rem 1rem;
            margin: 0.2rem 0;
            border-radius: 0.25rem;
        }
        
        .sidebar .nav-link:hover,
        .sidebar .nav-link.active {
            color: white;
            background-color: rgba(255, 255, 255, 0.1);
        }
        
        .sidebar .nav-link i {
            margin-left: 0.5rem;
        }
        
        .main-content {
            padding: 2rem;
        }
        
        .card {
            border-radius: 0.5rem;
            box-shadow: 0 0.125rem 0.25rem rgba(0, 0, 0, 0.075);
            margin-bottom: 1.5rem;
        }
        
        .card-header {
            background-color: white;
            border-bottom: 1px solid rgba(0, 0, 0, 0.125);
            font-weight: 600;
        }
        
        .btn-primary {
            background-color: var(--primary-color);
            border-color: var(--primary-color);
        }
        
        .btn-success {
            background-color: var(--secondary-color);
            border-color: var(--secondary-color);
        }
        
        .btn-danger {
            background-color: var(--danger-color);
            border-color: var(--danger-color);
        }
        
        .footer {
            padding: 1rem;
            text-align: center;
            font-size: 0.875rem;
            color: #6c757d;
            border-top: 1px solid #dee2e6;
        }
    </style>
</head>
<body>
    <div class="container-fluid">
        <div class="row">
            <!-- القائمة الجانبية -->
            <div class="col-md-3 col-lg-2 d-md-block sidebar collapse">
                <div class="position-sticky">
                    <div class="text-center py-4">
                        <h4 class="mb-0">CodePlus</h4>
                        <p class="small mb-0">نظام الصرافة والحوالات</p>
                    </div>
                    
                    <ul class="nav flex-column">
                        <li class="nav-item">
                            <a class="nav-link <?php echo e(request()->is('dashboard') ? 'active' : ''); ?>" href="<?php echo e(route('dashboard')); ?>">
                                <i class="bi bi-speedometer2"></i>
                                لوحة التحكم
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link <?php echo e(request()->is('currencies*') ? 'active' : ''); ?>" href="<?php echo e(route('currencies.index')); ?>">
                                <i class="bi bi-cash-coin"></i>
                                العملات
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link <?php echo e(request()->is('exchange-rates*') ? 'active' : ''); ?>" href="<?php echo e(route('exchange-rates.index')); ?>">
                                <i class="bi bi-arrow-left-right"></i>
                                أسعار الصرف
                            </a>
                        </li>
                        <li class="nav-item">
                            
                        </li>
                        
                        <li class="nav-item">
                            <a class="nav-link <?php echo e(request()->is('remittances*') ? 'active' : ''); ?>" href="<?php echo e(route('remittances.index')); ?>">
                                <i class="bi bi-send"></i>
                                الحوالات
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link <?php echo e(request()->is('reports*') ? 'active' : ''); ?>" href="<?php echo e(route('reports.index')); ?>">
                                <i class="bi bi-bar-chart"></i>
                                التقارير
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link <?php echo e(request()->is('settings*') ? 'active' : ''); ?>" href="<?php echo e(route('settings.index')); ?>">
                                <i class="bi bi-gear"></i>
                                الإعدادات
                            </a>
                        </li>
                    </ul>
                </div>
            </div>
            
            <!-- المحتوى الرئيسي -->
            <main class="col-md-9 ms-sm-auto col-lg-10 px-md-4 main-content">
                <!-- شريط التنقل العلوي -->
                <div class="d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pt-3 pb-2 mb-3 border-bottom">
                    <h1 class="h2"><?php echo $__env->yieldContent('title'); ?></h1>
                    <div class="btn-toolbar mb-2 mb-md-0">
                        <div class="dropdown">
                            <button class="btn btn-sm btn-outline-secondary dropdown-toggle" type="button" id="userDropdown" data-bs-toggle="dropdown" aria-expanded="false">
                                <i class="bi bi-person-circle"></i>
                                <?php echo e(Auth::user()->name ?? 'المستخدم'); ?>

                            </button>
                            <ul class="dropdown-menu dropdown-menu-end" aria-labelledby="userDropdown">
                                <li><a class="dropdown-item" href="#">الملف الشخصي</a></li>
                                <li><hr class="dropdown-divider"></li>
                                <li>
                                    
                                </li>
                            </ul>
                        </div>
                    </div>
                </div>
                
                <!-- رسائل التنبيه -->
                <?php if(session('success')): ?>
                <div class="alert alert-success alert-dismissible fade show" role="alert">
                    <?php echo e(session('success')); ?>

                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="إغلاق"></button>
                </div>
                <?php endif; ?>
                
                <?php if(session('error')): ?>
                <div class="alert alert-danger alert-dismissible fade show" role="alert">
                    <?php echo e(session('error')); ?>

                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="إغلاق"></button>
                </div>
                <?php endif; ?>
                
                <!-- المحتوى -->
                <?php echo $__env->yieldContent('content'); ?>
                
                <!-- التذييل -->
                <footer class="footer mt-auto">
                    <div class="container">
                        <span>جميع الحقوق محفوظة &copy; <?php echo e(date('Y')); ?> CodePlus - نظام الصرافة والحوالات المالية</span>
                    </div>
                </footer>
            </main>
        </div>
    </div>
    
    <!-- السكريبتات -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/chart.js@4.0.0/dist/chart.umd.min.js"></script>
    <script>
        // سكريبتات إضافية
        <?php echo $__env->yieldContent('scripts'); ?>
    </script>
</body>
</html>
<?php /**PATH D:\laragon\www\currencyexchange\resources\views/layouts/app.blade.php ENDPATH**/ ?>