@extends('layouts.app')

@section('title', 'إدارة الحوالات المالية')

@section('content')
<div class="container-fluid">
    <div class="card">
        <div class="card-header d-flex justify-content-between align-items-center">
            <h5 class="mb-0">قائمة الحوالات المالية</h5>
            <button type="button" class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#addRemittanceModal">
                <i class="bi bi-plus-lg"></i> إضافة حوالة جديدة
            </button>
        </div>
        <div class="card-body">
            <!-- فلاتر البحث -->
            <div class="row mb-3">
                <div class="col-md-12">
                    <form action="{{ route('remittances.index') }}" method="GET" class="row g-3">
                        <div class="col-md-2">
                            <input type="text" class="form-control" name="remittance_number" placeholder="رقم الحوالة" value="{{ request('remittance_number') }}">
                        </div>
                        <div class="col-md-2">
                            <input type="text" class="form-control" name="sender_name" placeholder="اسم المرسل" value="{{ request('sender_name') }}">
                        </div>
                        <div class="col-md-2">
                            <input type="text" class="form-control" name="receiver_name" placeholder="اسم المستلم" value="{{ request('receiver_name') }}">
                        </div>
                        <div class="col-md-2">
                            <select class="form-select" name="status">
                                <option value="">الحالة</option>
                                <option value="pending" {{ request('status') == 'pending' ? 'selected' : '' }}>معلقة</option>
                                <option value="sent" {{ request('status') == 'sent' ? 'selected' : '' }}>مرسلة</option>
                                <option value="received" {{ request('status') == 'received' ? 'selected' : '' }}>مستلمة</option>
                                <option value="cancelled" {{ request('status') == 'cancelled' ? 'selected' : '' }}>ملغاة</option>
                            </select>
                        </div>
                        <div class="col-md-2">
                            <input type="date" class="form-control" name="start_date" placeholder="من تاريخ" value="{{ request('start_date') }}">
                        </div>
                        <div class="col-md-2">
                            <div class="d-flex">
                                <input type="date" class="form-control" name="end_date" placeholder="إلى تاريخ" value="{{ request('end_date') }}">
                                <button type="submit" class="btn btn-primary ms-2">
                                    <i class="bi bi-search"></i>
                                </button>
                                <a href="{{ route('remittances.index') }}" class="btn btn-secondary ms-1">
                                    <i class="bi bi-x-lg"></i>
                                </a>
                            </div>
                        </div>
                    </form>
                </div>
            </div>

            <div class="table-responsive">
                <table class="table table-hover">
                    <thead>
                        <tr>
                            <th>رقم الحوالة</th>
                            <th>المرسل</th>
                            <th>المستلم</th>
                            <th>المبلغ المرسل</th>
                            <th>المبلغ المستلم</th>
                            <th>العمولة</th>
                            <th>الحالة</th>
                            <th>تاريخ الإرسال</th>
                            <th>تاريخ الاستلام</th>
                            <th>الإجراءات</th>
                        </tr>
                    </thead>
                    <tbody>
                        @if(isset($remittances) && count($remittances) > 0)
                            @foreach($remittances as $remittance)
                                <tr>
                                    <td>{{ $remittance->remittance_number }}</td>
                                    <td>{{ $remittance->sender->name ?? $remittance->sender_name }}</td>
                                    <td>{{ $remittance->receiver_name }}</td>
                                    <td>
                                        <div class="d-flex align-items-center">
                                            <span class="me-1">{{ $remittance->fromCurrency->symbol }}</span>
                                            {{ number_format($remittance->from_amount, 2) }}
                                            <small class="text-muted ms-1">{{ $remittance->fromCurrency->code }}</small>
                                        </div>
                                    </td>
                                    <td>
                                        <div class="d-flex align-items-center">
                                            <span class="me-1">{{ $remittance->toCurrency->symbol }}</span>
                                            {{ number_format($remittance->to_amount, 2) }}
                                            <small class="text-muted ms-1">{{ $remittance->toCurrency->code }}</small>
                                        </div>
                                    </td>
                                    <td>{{ number_format($remittance->commission, 2) }}</td>
                                    <td>
                                        @if($remittance->status == 'pending')
                                            <span class="badge bg-warning">معلقة</span>
                                        @elseif($remittance->status == 'sent')
                                            <span class="badge bg-info">مرسلة</span>
                                        @elseif($remittance->status == 'received')
                                            <span class="badge bg-success">مستلمة</span>
                                        @else
                                            <span class="badge bg-danger">ملغاة</span>
                                        @endif
                                    </td>
                                    <td>{{ $remittance->created_at->format('Y-m-d') }}</td>
                                    <td>{{ $remittance->received_at ? date('Y-m-d', strtotime($remittance->received_at)) : '-' }}</td>
                                    <td>
                                        <div class="btn-group" role="group">
                                            <button type="button" class="btn btn-sm btn-info" data-bs-toggle="modal" data-bs-target="#viewRemittanceModal{{ $remittance->id }}">
                                                <i class="bi bi-eye"></i>
                                            </button>
                                            <button type="button" class="btn btn-sm btn-warning" data-bs-toggle="modal" data-bs-target="#editRemittanceModal{{ $remittance->id }}">
                                                <i class="bi bi-pencil"></i>
                                            </button>
                                            <button type="button" class="btn btn-sm btn-success" data-bs-toggle="modal" data-bs-target="#receiveRemittanceModal{{ $remittance->id }}" {{ $remittance->status != 'sent' ? 'disabled' : '' }}>
                                                <i class="bi bi-check-lg"></i>
                                            </button>
                                            <button type="button" class="btn btn-sm btn-danger" data-bs-toggle="modal" data-bs-target="#cancelRemittanceModal{{ $remittance->id }}" {{ in_array($remittance->status, ['received', 'cancelled']) ? 'disabled' : '' }}>
                                                <i class="bi bi-x-lg"></i>
                                            </button>
                                        </div>
                                    </td>
                                </tr>
                            @endforeach
                        @else
                            <tr>
                                <td colspan="10" class="text-center">لا توجد حوالات مسجلة</td>
                            </tr>
                        @endif
                    </tbody>
                </table>
            </div>

            <!-- ترقيم الصفحات -->
            @if(isset($remittances) && $remittances instanceof \Illuminate\Pagination\LengthAwarePaginator)
                <div class="d-flex justify-content-center mt-3">
                    {{ $remittances->appends(request()->query())->links() }}
                </div>
            @endif
        </div>
    </div>
</div>

<!-- نافذة إضافة حوالة جديدة -->
<div class="modal fade" id="addRemittanceModal" tabindex="-1" aria-labelledby="addRemittanceModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <form action="{{ route('remittances.store') }}" method="POST">
                @csrf
                <div class="modal-header">
                    <h5 class="modal-title" id="addRemittanceModalLabel">إضافة حوالة جديدة</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="إغلاق"></button>
                </div>
                <div class="modal-body">
                    <div class="row">
                        <div class="col-md-6">
                            <h6 class="mb-3">بيانات المرسل</h6>
                            <div class="mb-3">
                                <label for="sender_id" class="form-label">اختر عميل مسجل</label>
                                <select class="form-select" id="sender_id" name="sender_id">
                                    <option value="">-- اختر العميل --</option>
                                    @if(isset($customers))
                                        @foreach($customers as $customer)
                                            <option value="{{ $customer->id }}">{{ $customer->name }}</option>
                                        @endforeach
                                    @endif
                                </select>
                                <div class="form-text">اختياري: يمكنك إدخال بيانات مرسل جديد أدناه</div>
                            </div>
                            <div class="mb-3">
                                <label for="sender_name" class="form-label">اسم المرسل <span class="text-danger">*</span></label>
                                <input type="text" class="form-control" id="sender_name" name="sender_name" required>
                            </div>
                            <div class="mb-3">
                                <label for="sender_phone" class="form-label">رقم هاتف المرسل</label>
                                <input type="text" class="form-control" id="sender_phone" name="sender_phone">
                            </div>
                            <div class="mb-3">
                                <label for="sender_id_type" class="form-label">نوع هوية المرسل</label>
                                <select class="form-select" id="sender_id_type" name="sender_id_type">
                                    <option value="">-- اختر نوع الهوية --</option>
                                    <option value="جواز سفر">جواز سفر</option>
                                    <option value="بطاقة هوية">بطاقة هوية</option>
                                    <option value="إقامة">إقامة</option>
                                    <option value="رخصة قيادة">رخصة قيادة</option>
                                    <option value="أخرى">أخرى</option>
                                </select>
                            </div>
                            <div class="mb-3">
                                <label for="sender_id_number" class="form-label">رقم هوية المرسل</label>
                                <input type="text" class="form-control" id="sender_id_number" name="sender_id_number">
                            </div>
                        </div>
                        <div class="col-md-6">
                            <h6 class="mb-3">بيانات المستلم</h6>
                            <div class="mb-3">
                                <label for="receiver_name" class="form-label">اسم المستلم <span class="text-danger">*</span></label>
                                <input type="text" class="form-control" id="receiver_name" name="receiver_name" required>
                            </div>
                            <div class="mb-3">
                                <label for="receiver_phone" class="form-label">رقم هاتف المستلم</label>
                                <input type="text" class="form-control" id="receiver_phone" name="receiver_phone">
                            </div>
                            <div class="mb-3">
                                <label for="receiver_id_type" class="form-label">نوع هوية المستلم</label>
                                <select class="form-select" id="receiver_id_type" name="receiver_id_type">
                                    <option value="">-- اختر نوع الهوية --</option>
                                    <option value="جواز سفر">جواز سفر</option>
                                    <option value="بطاقة هوية">بطاقة هوية</option>
                                    <option value="إقامة">إقامة</option>
                                    <option value="رخصة قيادة">رخصة قيادة</option>
                                    <option value="أخرى">أخرى</option>
                                </select>
                            </div>
                            <div class="mb-3">
                                <label for="receiver_id_number" class="form-label">رقم هوية المستلم</label>
                                <input type="text" class="form-control" id="receiver_id_number" name="receiver_id_number">
                            </div>
                            <div class="mb-3">
                                <label for="receiver_address" class="form-label">عنوان المستلم</label>
                                <input type="text" class="form-control" id="receiver_address" name="receiver_address">
                            </div>
                        </div>
                    </div>
                    <hr>
                    <div class="row">
                        <div class="col-md-12">
                            <h6 class="mb-3">بيانات الحوالة</h6>
                        </div>
                        <div class="col-md-6 mb-3">
                            <label for="from_currency_id" class="form-label">عملة الإرسال <span class="text-danger">*</span></label>
                            <select class="form-select" id="from_currency_id" name="from_currency_id" required>
                                <option value="">-- اختر العملة --</option>
                                @if(isset($currencies))
                                    @foreach($currencies as $currency)
                                        <option value="{{ $currency->id }}">{{ $currency->code }} - {{ $currency->name }}</option>
                                    @endforeach
                                @endif
                            </select>
                        </div>
                        <div class="col-md-6 mb-3">
                            <label for="to_currency_id" class="form-label">عملة الاستلام <span class="text-danger">*</span></label>
                            <select class="form-select" id="to_currency_id" name="to_currency_id" required>
                                <option value="">-- اختر العملة --</option>
                                @if(isset($currencies))
                                    @foreach($currencies as $currency)
                                        <option value="{{ $currency->id }}">{{ $currency->code }} - {{ $currency->name }}</option>
                                    @endforeach
                                @endif
                            </select>
                        </div>
                        <div class="col-md-6 mb-3">
                            <label for="from_amount" class="form-label">المبلغ المرسل <span class="text-danger">*</span></label>
                            <input type="number" class="form-control" id="from_amount" name="from_amount" required step="0.01" min="0.01">
                        </div>
                        <div class="col-md-6 mb-3">
                            <label for="exchange_rate" class="form-label">سعر الصرف <span class="text-danger">*</span></label>
                            <input type="number" class="form-control" id="exchange_rate" name="exchange_rate" required step="0.000001" min="0.000001">
                            <div class="form-text">سيتم تحديث هذا الحقل تلقائيًا عند اختيار العملات</div>
                        </div>
                        <div class="col-md-6 mb-3">
                            <label for="to_amount" class="form-label">المبلغ المستلم</label>
                            <input type="number" class="form-control" id="to_amount" name="to_amount" readonly step="0.01">
                            <div class="form-text">سيتم حساب هذا الحقل تلقائيًا</div>
                        </div>
                        <div class="col-md-6 mb-3">
                            <label for="commission" class="form-label">العمولة</label>
                            <input type="number" class="form-control" id="commission" name="commission" step="0.01" min="0" value="0">
                        </div>
                        <div class="col-md-6 mb-3">
                            <label for="purpose" class="form-label">الغرض من التحويل</label>
                            <select class="form-select" id="purpose" name="purpose">
                                <option value="عائلي">عائلي</option>
                                <option value="تجاري">تجاري</option>
                                <option value="شخصي">شخصي</option>
                                <option value="تعليمي">تعليمي</option>
                                <option value="آخر">آخر</option>
                            </select>
                        </div>
                        <div class="col-md-6 mb-3">
                            <label for="payment_method" class="form-label">طريقة الدفع</label>
                            <select class="form-select" id="payment_method" name="payment_method">
                                <option value="نقدي">نقدي</option>
                                <option value="بطاقة">بطاقة</option>
                                <option value="تحويل بنكي">تحويل بنكي</option>
                                <option value="آخر">آخر</option>
                            </select>
                        </div>
                        <div class="col-md-12 mb-3">
                            <label for="notes" class="form-label">ملاحظات</label>
                            <textarea class="form-control" id="notes" name="notes" rows="3"></textarea>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">إلغاء</button>
                    <button type="submit" class="btn btn-primary">حفظ</button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- نوافذ عرض وتعديل واستلام وإلغاء الحوالات (ستتم إضافتها ديناميكيًا لكل حوالة) -->
@if(isset($remittances))
    @foreach($remittances as $remittance)
        <!-- نافذة عرض تفاصيل الحوالة -->
        <div class="modal fade" id="viewRemittanceModal{{ $remittance->id }}" tabindex="-1" aria-labelledby="viewRemittanceModalLabel{{ $remittance->id }}" aria-hidden="true">
            <div class="modal-dialog modal-lg">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="viewRemittanceModalLabel{{ $remittance->id }}">تفاصيل الحوالة #{{ $remittance->remittance_number }}</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="إغلاق"></button>
                    </div>
                    <div class="modal-body">
                        <div class="row">
                            <div class="col-md-6">
                                <h6 class="border-bottom pb-2">بيانات المرسل</h6>
                                <table class="table table-sm table-borderless">
                                    <tr>
                                        <th>الاسم:</th>
                                        <td>{{ $remittance->sender->name ?? $remittance->sender_name }}</td>
                                    </tr>
                                    <tr>
                                        <th>رقم الهاتف:</th>
                                        <td>{{ $remittance->sender_phone ?? 'غير متوفر' }}</td>
                                    </tr>
                                    <tr>
                                        <th>نوع الهوية:</th>
                                        <td>{{ $remittance->sender_id_type ?? 'غير متوفر' }}</td>
                                    </tr>
                                    <tr>
                                        <th>رقم الهوية:</th>
                                        <td>{{ $remittance->sender_id_number ?? 'غير متوفر' }}</td>
                                    </tr>
                                </table>
                            </div>
                            <div class="col-md-6">
                                <h6 class="border-bottom pb-2">بيانات المستلم</h6>
                                <table class="table table-sm table-borderless">
                                    <tr>
                                        <th>الاسم:</th>
                                        <td>{{ $remittance->receiver_name }}</td>
                                    </tr>
                                    <tr>
                                        <th>رقم الهاتف:</th>
                                        <td>{{ $remittance->receiver_phone ?? 'غير متوفر' }}</td>
                                    </tr>
                                    <tr>
                                        <th>نوع الهوية:</th>
                                        <td>{{ $remittance->receiver_id_type ?? 'غير متوفر' }}</td>
                                    </tr>
                                    <tr>
                                        <th>رقم الهوية:</th>
                                        <td>{{ $remittance->receiver_id_number ?? 'غير متوفر' }}</td>
                                    </tr>
                                    <tr>
                                        <th>العنوان:</th>
                                        <td>{{ $remittance->receiver_address ?? 'غير متوفر' }}</td>
                                    </tr>
                                </table>
                            </div>
                        </div>
                        <hr>
                        <div class="row">
                            <div class="col-md-12">
                                <h6 class="border-bottom pb-2">بيانات الحوالة</h6>
                                <div class="row">
                                    <div class="col-md-6">
                                        <table class="table table-sm table-borderless">
                                            <tr>
                                                <th>رقم الحوالة:</th>
                                                <td>{{ $remittance->remittance_number }}</td>
                                            </tr>
                                            <tr>
                                                <th>المبلغ المرسل:</th>
                                                <td>{{ number_format($remittance->from_amount, 2) }} {{ $remittance->fromCurrency->code }}</td>
                                            </tr>
                                            <tr>
                                                <th>سعر الصرف:</th>
                                                <td>{{ number_format($remittance->exchange_rate, 6) }}</td>
                                            </tr>
                                            <tr>
                                                <th>المبلغ المستلم:</th>
                                                <td>{{ number_format($remittance->to_amount, 2) }} {{ $remittance->toCurrency->code }}</td>
                                            </tr>
                                            <tr>
                                                <th>العمولة:</th>
                                                <td>{{ number_format($remittance->commission, 2) }}</td>
                                            </tr>
                                        </table>
                                    </div>
                                    <div class="col-md-6">
                                        <table class="table table-sm table-borderless">
                                            <tr>
                                                <th>الغرض من التحويل:</th>
                                                <td>{{ $remittance->purpose ?? 'غير محدد' }}</td>
                                            </tr>
                                            <tr>
                                                <th>طريقة الدفع:</th>
                                                <td>{{ $remittance->payment_method ?? 'غير محدد' }}</td>
                                            </tr>
                                            <tr>
                                                <th>الحالة:</th>
                                                <td>
                                                    @if($remittance->status == 'pending')
                                                        <span class="badge bg-warning">معلقة</span>
                                                    @elseif($remittance->status == 'sent')
                                                        <span class="badge bg-info">مرسلة</span>
                                                    @elseif($remittance->status == 'received')
                                                        <span class="badge bg-success">مستلمة</span>
                                                    @else
                                                        <span class="badge bg-danger">ملغاة</span>
                                                    @endif
                                                </td>
                                            </tr>
                                            <tr>
                                                <th>تاريخ الإرسال:</th>
                                                <td>{{ $remittance->created_at->format('Y-m-d H:i:s') }}</td>
                                            </tr>
                                            <tr>
                                                <th>تاريخ الاستلام:</th>
                                                <td>{{ $remittance->received_at ? date('Y-m-d H:i:s', strtotime($remittance->received_at)) : 'لم يتم الاستلام بعد' }}</td>
                                            </tr>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                        @if($remittance->notes)
                            <div class="row mt-3">
                                <div class="col-md-12">
                                    <h6 class="border-bottom pb-2">ملاحظات</h6>
                                    <p>{{ $remittance->notes }}</p>
                                </div>
                            </div>
                        @endif
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">إغلاق</button>
                        <button type="button" class="btn btn-primary" onclick="printRemittance({{ $remittance->id }})">طباعة</button>
                    </div>
                </div>
            </div>
        </div>

        <!-- نافذة تعديل الحوالة -->
        <div class="modal fade" id="editRemittanceModal{{ $remittance->id }}" tabindex="-1" aria-labelledby="editRemittanceModalLabel{{ $remittance->id }}" aria-hidden="true">
            <div class="modal-dialog">
                <div class="modal-content">
                    <form action="{{ route('remittances.update', $remittance->id) }}" method="POST">
                        @csrf
                        @method('PUT')
                        <div class="modal-header">
                            <h5 class="modal-title" id="editRemittanceModalLabel{{ $remittance->id }}">تعديل الحوالة #{{ $remittance->remittance_number }}</h5>
                            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="إغلاق"></button>
                        </div>
                        <div class="modal-body">
                            <div class="alert alert-warning">
                                <i class="bi bi-exclamation-triangle"></i>
                                ملاحظة: يمكن تعديل بيانات المستلم فقط إذا كانت الحوالة في حالة معلقة أو مرسلة.
                            </div>
                            
                            @if(in_array($remittance->status, ['pending', 'sent']))
                                <div class="mb-3">
                                    <label for="edit_receiver_name{{ $remittance->id }}" class="form-label">اسم المستلم <span class="text-danger">*</span></label>
                                    <input type="text" class="form-control" id="edit_receiver_name{{ $remittance->id }}" name="receiver_name" required value="{{ $remittance->receiver_name }}">
                                </div>
                                <div class="mb-3">
                                    <label for="edit_receiver_phone{{ $remittance->id }}" class="form-label">رقم هاتف المستلم</label>
                                    <input type="text" class="form-control" id="edit_receiver_phone{{ $remittance->id }}" name="receiver_phone" value="{{ $remittance->receiver_phone }}">
                                </div>
                                <div class="mb-3">
                                    <label for="edit_receiver_id_type{{ $remittance->id }}" class="form-label">نوع هوية المستلم</label>
                                    <select class="form-select" id="edit_receiver_id_type{{ $remittance->id }}" name="receiver_id_type">
                                        <option value="">-- اختر نوع الهوية --</option>
                                        <option value="جواز سفر" {{ $remittance->receiver_id_type == 'جواز سفر' ? 'selected' : '' }}>جواز سفر</option>
                                        <option value="بطاقة هوية" {{ $remittance->receiver_id_type == 'بطاقة هوية' ? 'selected' : '' }}>بطاقة هوية</option>
                                        <option value="إقامة" {{ $remittance->receiver_id_type == 'إقامة' ? 'selected' : '' }}>إقامة</option>
                                        <option value="رخصة قيادة" {{ $remittance->receiver_id_type == 'رخصة قيادة' ? 'selected' : '' }}>رخصة قيادة</option>
                                        <option value="أخرى" {{ $remittance->receiver_id_type == 'أخرى' ? 'selected' : '' }}>أخرى</option>
                                    </select>
                                </div>
                                <div class="mb-3">
                                    <label for="edit_receiver_id_number{{ $remittance->id }}" class="form-label">رقم هوية المستلم</label>
                                    <input type="text" class="form-control" id="edit_receiver_id_number{{ $remittance->id }}" name="receiver_id_number" value="{{ $remittance->receiver_id_number }}">
                                </div>
                                <div class="mb-3">
                                    <label for="edit_receiver_address{{ $remittance->id }}" class="form-label">عنوان المستلم</label>
                                    <input type="text" class="form-control" id="edit_receiver_address{{ $remittance->id }}" name="receiver_address" value="{{ $remittance->receiver_address }}">
                                </div>
                                <div class="mb-3">
                                    <label for="edit_notes{{ $remittance->id }}" class="form-label">ملاحظات</label>
                                    <textarea class="form-control" id="edit_notes{{ $remittance->id }}" name="notes" rows="3">{{ $remittance->notes }}</textarea>
                                </div>
                            @else
                                <p class="text-center">لا يمكن تعديل الحوالة في الحالة الحالية.</p>
                            @endif
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">إلغاء</button>
                            @if(in_array($remittance->status, ['pending', 'sent']))
                                <button type="submit" class="btn btn-primary">حفظ التغييرات</button>
                            @endif
                        </div>
                    </form>
                </div>
            </div>
        </div>

        <!-- نافذة استلام الحوالة -->
        <div class="modal fade" id="receiveRemittanceModal{{ $remittance->id }}" tabindex="-1" aria-labelledby="receiveRemittanceModalLabel{{ $remittance->id }}" aria-hidden="true">
            <div class="modal-dialog">
                <div class="modal-content">
                    <form action="{{ route('remittances.receive', $remittance->id) }}" method="POST">
                        @csrf
                        @method('PUT')
                        <div class="modal-header">
                            <h5 class="modal-title" id="receiveRemittanceModalLabel{{ $remittance->id }}">تأكيد استلام الحوالة</h5>
                            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="إغلاق"></button>
                        </div>
                        <div class="modal-body">
                            <p>هل تريد تأكيد استلام الحوالة رقم {{ $remittance->remittance_number }}؟</p>
                            
                            <div class="mb-3">
                                <label for="receiver_id_type_confirm{{ $remittance->id }}" class="form-label">نوع هوية المستلم <span class="text-danger">*</span></label>
                                <select class="form-select" id="receiver_id_type_confirm{{ $remittance->id }}" name="receiver_id_type" required>
                                    <option value="">-- اختر نوع الهوية --</option>
                                    <option value="جواز سفر" {{ $remittance->receiver_id_type == 'جواز سفر' ? 'selected' : '' }}>جواز سفر</option>
                                    <option value="بطاقة هوية" {{ $remittance->receiver_id_type == 'بطاقة هوية' ? 'selected' : '' }}>بطاقة هوية</option>
                                    <option value="إقامة" {{ $remittance->receiver_id_type == 'إقامة' ? 'selected' : '' }}>إقامة</option>
                                    <option value="رخصة قيادة" {{ $remittance->receiver_id_type == 'رخصة قيادة' ? 'selected' : '' }}>رخصة قيادة</option>
                                    <option value="أخرى" {{ $remittance->receiver_id_type == 'أخرى' ? 'selected' : '' }}>أخرى</option>
                                </select>
                            </div>
                            <div class="mb-3">
                                <label for="receiver_id_number_confirm{{ $remittance->id }}" class="form-label">رقم هوية المستلم <span class="text-danger">*</span></label>
                                <input type="text" class="form-control" id="receiver_id_number_confirm{{ $remittance->id }}" name="receiver_id_number" required value="{{ $remittance->receiver_id_number }}">
                            </div>
                            <div class="mb-3">
                                <label for="received_at{{ $remittance->id }}" class="form-label">تاريخ ووقت الاستلام <span class="text-danger">*</span></label>
                                <input type="datetime-local" class="form-control" id="received_at{{ $remittance->id }}" name="received_at" required value="{{ date('Y-m-d\TH:i') }}">
                            </div>
                            <div class="mb-3">
                                <label for="receive_notes{{ $remittance->id }}" class="form-label">ملاحظات الاستلام</label>
                                <textarea class="form-control" id="receive_notes{{ $remittance->id }}" name="notes" rows="3"></textarea>
                            </div>
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">إلغاء</button>
                            <button type="submit" class="btn btn-success">تأكيد الاستلام</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>

        <!-- نافذة إلغاء الحوالة -->
        <div class="modal fade" id="cancelRemittanceModal{{ $remittance->id }}" tabindex="-1" aria-labelledby="cancelRemittanceModalLabel{{ $remittance->id }}" aria-hidden="true">
            <div class="modal-dialog">
                <div class="modal-content">
                    <form action="{{ route('remittances.cancel', $remittance->id) }}" method="POST">
                        @csrf
                        @method('PUT')
                        <div class="modal-header">
                            <h5 class="modal-title" id="cancelRemittanceModalLabel{{ $remittance->id }}">تأكيد إلغاء الحوالة</h5>
                            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="إغلاق"></button>
                        </div>
                        <div class="modal-body">
                            <p>هل أنت متأكد من إلغاء الحوالة رقم {{ $remittance->remittance_number }}؟</p>
                            <div class="alert alert-danger">
                                <i class="bi bi-exclamation-triangle"></i>
                                تحذير: لا يمكن التراجع عن هذا الإجراء بعد تأكيده.
                            </div>
                            <div class="mb-3">
                                <label for="cancel_reason{{ $remittance->id }}" class="form-label">سبب الإلغاء <span class="text-danger">*</span></label>
                                <select class="form-select" id="cancel_reason{{ $remittance->id }}" name="cancel_reason" required>
                                    <option value="">-- اختر سبب الإلغاء --</option>
                                    <option value="طلب المرسل">طلب المرسل</option>
                                    <option value="بيانات خاطئة">بيانات خاطئة</option>
                                    <option value="مشكلة في التحويل">مشكلة في التحويل</option>
                                    <option value="مشكلة في الدفع">مشكلة في الدفع</option>
                                    <option value="سبب آخر">سبب آخر</option>
                                </select>
                            </div>
                            <div class="mb-3">
                                <label for="cancel_notes{{ $remittance->id }}" class="form-label">ملاحظات الإلغاء</label>
                                <textarea class="form-control" id="cancel_notes{{ $remittance->id }}" name="notes" rows="3"></textarea>
                            </div>
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">إلغاء</button>
                            <button type="submit" class="btn btn-danger">تأكيد الإلغاء</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    @endforeach
@endif
@endsection

@section('scripts')
<script>
    // حساب المبلغ المستلم تلقائيًا
    document.addEventListener('DOMContentLoaded', function() {
        const fromAmountInput = document.getElementById('from_amount');
        const exchangeRateInput = document.getElementById('exchange_rate');
        const toAmountInput = document.getElementById('to_amount');
        
        function calculateToAmount() {
            const fromAmount = parseFloat(fromAmountInput.value) || 0;
            const exchangeRate = parseFloat(exchangeRateInput.value) || 0;
            const toAmount = fromAmount * exchangeRate;
            toAmountInput.value = toAmount.toFixed(2);
        }
        
        if (fromAmountInput && exchangeRateInput && toAmountInput) {
            fromAmountInput.addEventListener('input', calculateToAmount);
            exchangeRateInput.addEventListener('input', calculateToAmount);
            
            // تحديث سعر الصرف عند اختيار العملات
            const fromCurrencySelect = document.getElementById('from_currency_id');
            const toCurrencySelect = document.getElementById('to_currency_id');
            
            function updateExchangeRate() {
                const fromCurrencyId = fromCurrencySelect.value;
                const toCurrencyId = toCurrencySelect.value;
                
                if (fromCurrencyId && toCurrencyId) {
                    // هنا يمكن إضافة طلب AJAX للحصول على سعر الصرف الحالي من الخادم
                    // لأغراض العرض، نستخدم قيمة افتراضية
                    exchangeRateInput.value = '1.0000';
                    calculateToAmount();
                }
            }
            
            fromCurrencySelect.addEventListener('change', updateExchangeRate);
            toCurrencySelect.addEventListener('change', updateExchangeRate);
            
            // تعبئة بيانات المرسل تلقائيًا عند اختيار عميل مسجل
            const senderIdSelect = document.getElementById('sender_id');
            const senderNameInput = document.getElementById('sender_name');
            const senderPhoneInput = document.getElementById('sender_phone');
            
            if (senderIdSelect) {
                senderIdSelect.addEventListener('change', function() {
                    const selectedOption = this.options[this.selectedIndex];
                    if (selectedOption.value) {
                        // هنا يمكن إضافة طلب AJAX للحصول على بيانات العميل من الخادم
                        // لأغراض العرض، نستخدم قيم افتراضية
                        senderNameInput.value = selectedOption.text;
                        // senderPhoneInput.value = '...'; // يمكن تعبئته من خلال طلب AJAX
                    } else {
                        senderNameInput.value = '';
                        senderPhoneInput.value = '';
                    }
                });
            }
        }
    });
    
    // وظيفة طباعة الحوالة
    function printRemittance(id) {
        const printWindow = window.open('', '_blank');
        const modalContent = document.querySelector(`#viewRemittanceModal${id} .modal-body`).innerHTML;
        
        printWindow.document.write(`
            <!DOCTYPE html>
            <html dir="rtl">
            <head>
                <title>طباعة الحوالة</title>
                <meta charset="UTF-8">
                <meta name="viewport" content="width=device-width, initial-scale=1.0">
                <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
                <style>
                    body {
                        font-family: 'Tajawal', sans-serif;
                        padding: 20px;
                    }
                    .header {
                        text-align: center;
                        margin-bottom: 20px;
                    }
                    .footer {
                        text-align: center;
                        margin-top: 30px;
                        font-size: 14px;
                    }
                    @media print {
                        @page {
                            size: A4;
                            margin: 10mm;
                        }
                    }
                </style>
            </head>
            <body>
                <div class="header">
                    <h3>CodePlus - نظام الصرافة والحوالات</h3>
                    <h4>إيصال حوالة</h4>
                </div>
                ${modalContent}
                <div class="footer">
                    <p>جميع الحقوق محفوظة © ${new Date().getFullYear()} CodePlus - نظام الصرافة والحوالات</p>
                </div>
                <script>
                    window.onload = function() {
                        window.print();
                        setTimeout(function() {
                            window.close();
                        }, 500);
                    };
                </script>
            </body>
            </html>
        `);
        
        printWindow.document.close();
    }
</script>
@endsection
