@extends('layouts.app')

@section('title', 'إدارة أسعار الصرف')

@section('content')
<div class="container-fluid">
    <div class="card">
        <div class="card-header d-flex justify-content-between align-items-center">
            <h5 class="mb-0">أسعار الصرف الحالية</h5>
            <button type="button" class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#addExchangeRateModal">
                <i class="bi bi-plus-lg"></i> إضافة سعر صرف جديد
            </button>
        </div>
        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-hover">
                    <thead>
                        <tr>
                            <th>#</th>
                            <th>من العملة</th>
                            <th>إلى العملة</th>
                            <th>سعر الشراء</th>
                            <th>سعر البيع</th>
                            <th>تاريخ السريان</th>
                            <th>الحالة</th>
                            <th>الإجراءات</th>
                        </tr>
                    </thead>
                    <tbody>
                        @if(isset($exchangeRates) && count($exchangeRates) > 0)
                            @foreach($exchangeRates as $rate)
                                <tr>
                                    <td>{{ $loop->iteration }}</td>
                                    <td>
                                        <div class="d-flex align-items-center">
                                            <span class="me-2">{{ $rate->fromCurrency->symbol }}</span>
                                            {{ $rate->fromCurrency->code }}
                                        </div>
                                    </td>
                                    <td>
                                        <div class="d-flex align-items-center">
                                            <span class="me-2">{{ $rate->toCurrency->symbol }}</span>
                                            {{ $rate->toCurrency->code }}
                                        </div>
                                    </td>
                                    <td>{{ number_format($rate->buy_rate, 6) }}</td>
                                    <td>{{ number_format($rate->sell_rate, 6) }}</td>
                                    <td>{{ $rate->effective_date }}</td>
                                    <td>
                                        @if($rate->is_active)
                                            <span class="badge bg-success">نشط</span>
                                        @else
                                            <span class="badge bg-danger">غير نشط</span>
                                        @endif
                                    </td>
                                    <td>
                                        <div class="btn-group" role="group">
                                            <button type="button" class="btn btn-sm btn-info" data-bs-toggle="modal" data-bs-target="#editExchangeRateModal{{ $rate->id }}">
                                                <i class="bi bi-pencil"></i>
                                            </button>
                                            <button type="button" class="btn btn-sm btn-danger" data-bs-toggle="modal" data-bs-target="#deleteExchangeRateModal{{ $rate->id }}">
                                                <i class="bi bi-trash"></i>
                                            </button>
                                        </div>
                                    </td>
                                </tr>
                            @endforeach
                        @else
                            <tr>
                                <td colspan="8" class="text-center">لا توجد أسعار صرف مسجلة</td>
                            </tr>
                        @endif
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>

<!-- نافذة إضافة سعر صرف جديد -->
<div class="modal fade" id="addExchangeRateModal" tabindex="-1" aria-labelledby="addExchangeRateModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <form action="{{ route('exchange-rates.store') }}" method="POST">
                @csrf
                <div class="modal-header">
                    <h5 class="modal-title" id="addExchangeRateModalLabel">إضافة سعر صرف جديد</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="إغلاق"></button>
                </div>
                <div class="modal-body">
                    <div class="mb-3">
                        <label for="from_currency_id" class="form-label">من العملة <span class="text-danger">*</span></label>
                        <select class="form-select" id="from_currency_id" name="from_currency_id" required>
                            <option value="">-- اختر العملة --</option>
                            @if(isset($currencies))
                                @foreach($currencies as $currency)
                                    <option value="{{ $currency->id }}">{{ $currency->code }} - {{ $currency->name }}</option>
                                @endforeach
                            @endif
                        </select>
                    </div>
                    <div class="mb-3">
                        <label for="to_currency_id" class="form-label">إلى العملة <span class="text-danger">*</span></label>
                        <select class="form-select" id="to_currency_id" name="to_currency_id" required>
                            <option value="">-- اختر العملة --</option>
                            @if(isset($currencies))
                                @foreach($currencies as $currency)
                                    <option value="{{ $currency->id }}">{{ $currency->code }} - {{ $currency->name }}</option>
                                @endforeach
                            @endif
                        </select>
                    </div>
                    <div class="mb-3">
                        <label for="rate" class="form-label">سعر الصرف الأساسي <span class="text-danger">*</span></label>
                        <input type="number" class="form-control" id="rate" name="rate" required step="0.000001" min="0.000001">
                    </div>
                    <div class="mb-3">
                        <label for="buy_rate" class="form-label">سعر الشراء</label>
                        <input type="number" class="form-control" id="buy_rate" name="buy_rate" step="0.000001" min="0.000001">
                        <div class="form-text">إذا تركت هذا الحقل فارغًا، سيتم استخدام سعر الصرف الأساسي</div>
                    </div>
                    <div class="mb-3">
                        <label for="sell_rate" class="form-label">سعر البيع</label>
                        <input type="number" class="form-control" id="sell_rate" name="sell_rate" step="0.000001" min="0.000001">
                        <div class="form-text">إذا تركت هذا الحقل فارغًا، سيتم استخدام سعر الصرف الأساسي</div>
                    </div>
                    <div class="mb-3">
                        <label for="effective_date" class="form-label">تاريخ السريان <span class="text-danger">*</span></label>
                        <input type="datetime-local" class="form-control" id="effective_date" name="effective_date" required>
                    </div>
                    <div class="mb-3 form-check">
                        <input type="checkbox" class="form-check-input" id="is_active" name="is_active" checked>
                        <label class="form-check-label" for="is_active">نشط</label>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">إلغاء</button>
                    <button type="submit" class="btn btn-primary">حفظ</button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- نوافذ تعديل وحذف أسعار الصرف (ستتم إضافتها ديناميكيًا لكل سعر صرف) -->
@if(isset($exchangeRates))
    @foreach($exchangeRates as $rate)
        <!-- نافذة تعديل سعر الصرف -->
        <div class="modal fade" id="editExchangeRateModal{{ $rate->id }}" tabindex="-1" aria-labelledby="editExchangeRateModalLabel{{ $rate->id }}" aria-hidden="true">
            <div class="modal-dialog">
                <div class="modal-content">
                    <form action="{{ route('exchange-rates.update', $rate->id) }}" method="POST">
                        @csrf
                        @method('PUT')
                        <div class="modal-header">
                            <h5 class="modal-title" id="editExchangeRateModalLabel{{ $rate->id }}">تعديل سعر الصرف</h5>
                            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="إغلاق"></button>
                        </div>
                        <div class="modal-body">
                            <div class="mb-3">
                                <label class="form-label">من العملة</label>
                                <input type="text" class="form-control" value="{{ $rate->fromCurrency->code }} - {{ $rate->fromCurrency->name }}" readonly>
                                <input type="hidden" name="from_currency_id" value="{{ $rate->from_currency_id }}">
                            </div>
                            <div class="mb-3">
                                <label class="form-label">إلى العملة</label>
                                <input type="text" class="form-control" value="{{ $rate->toCurrency->code }} - {{ $rate->toCurrency->name }}" readonly>
                                <input type="hidden" name="to_currency_id" value="{{ $rate->to_currency_id }}">
                            </div>
                            <div class="mb-3">
                                <label for="edit_rate{{ $rate->id }}" class="form-label">سعر الصرف الأساسي <span class="text-danger">*</span></label>
                                <input type="number" class="form-control" id="edit_rate{{ $rate->id }}" name="rate" required step="0.000001" min="0.000001" value="{{ $rate->rate }}">
                            </div>
                            <div class="mb-3">
                                <label for="edit_buy_rate{{ $rate->id }}" class="form-label">سعر الشراء</label>
                                <input type="number" class="form-control" id="edit_buy_rate{{ $rate->id }}" name="buy_rate" step="0.000001" min="0.000001" value="{{ $rate->buy_rate }}">
                            </div>
                            <div class="mb-3">
                                <label for="edit_sell_rate{{ $rate->id }}" class="form-label">سعر البيع</label>
                                <input type="number" class="form-control" id="edit_sell_rate{{ $rate->id }}" name="sell_rate" step="0.000001" min="0.000001" value="{{ $rate->sell_rate }}">
                            </div>
                            <div class="mb-3">
                                <label for="edit_effective_date{{ $rate->id }}" class="form-label">تاريخ السريان <span class="text-danger">*</span></label>
                                <input type="datetime-local" class="form-control" id="edit_effective_date{{ $rate->id }}" name="effective_date" required value="{{ date('Y-m-d\TH:i', strtotime($rate->effective_date)) }}">
                            </div>
                            <div class="mb-3 form-check">
                                <input type="checkbox" class="form-check-input" id="edit_is_active{{ $rate->id }}" name="is_active" {{ $rate->is_active ? 'checked' : '' }}>
                                <label class="form-check-label" for="edit_is_active{{ $rate->id }}">نشط</label>
                            </div>
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">إلغاء</button>
                            <button type="submit" class="btn btn-primary">حفظ التغييرات</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>

        <!-- نافذة حذف سعر الصرف -->
        <div class="modal fade" id="deleteExchangeRateModal{{ $rate->id }}" tabindex="-1" aria-labelledby="deleteExchangeRateModalLabel{{ $rate->id }}" aria-hidden="true">
            <div class="modal-dialog">
                <div class="modal-content">
                    <form action="{{ route('exchange-rates.destroy', $rate->id) }}" method="POST">
                        @csrf
                        @method('DELETE')
                        <div class="modal-header">
                            <h5 class="modal-title" id="deleteExchangeRateModalLabel{{ $rate->id }}">تأكيد الحذف</h5>
                            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="إغلاق"></button>
                        </div>
                        <div class="modal-body">
                            <p>هل أنت متأكد من حذف سعر الصرف بين {{ $rate->fromCurrency->code }} و {{ $rate->toCurrency->code }}؟</p>
                            <div class="alert alert-warning">
                                <i class="bi bi-exclamation-triangle"></i>
                                تحذير: قد يؤثر حذف سعر الصرف هذا على المعاملات والحوالات المرتبطة به.
                            </div>
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">إلغاء</button>
                            <button type="submit" class="btn btn-danger">تأكيد الحذف</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    @endforeach
@endif
@endsection

@section('scripts')
<script>
    // تحديث سعر الشراء والبيع تلقائيًا عند تغيير سعر الصرف الأساسي
    document.getElementById('rate').addEventListener('input', function() {
        const rate = parseFloat(this.value) || 0;
        document.getElementById('buy_rate').value = rate;
        document.getElementById('sell_rate').value = rate;
    });
</script>
@endsection
