@extends('layouts.app')

@section('title', 'لوحة التحكم')

@section('content')
<div class="container-fluid">
    <!-- إحصائيات سريعة -->
    <div class="row mb-4">
        <div class="col-md-3">
            <div class="card text-white bg-primary">
                <div class="card-body">
                    <div class="d-flex justify-content-between align-items-center">
                        <div>
                            <h6 class="card-title">إجمالي المعاملات</h6>
                            <h2 class="mb-0">{{ $transactionsCount ?? 0 }}</h2>
                        </div>
                        <i class="bi bi-currency-exchange fs-1"></i>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card text-white bg-success">
                <div class="card-body">
                    <div class="d-flex justify-content-between align-items-center">
                        <div>
                            <h6 class="card-title">إجمالي الحوالات</h6>
                            <h2 class="mb-0">{{ $remittancesCount ?? 0 }}</h2>
                        </div>
                        <i class="bi bi-send fs-1"></i>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card text-white bg-info">
                <div class="card-body">
                    <div class="d-flex justify-content-between align-items-center">
                        <div>
                            <h6 class="card-title">العملاء</h6>
                            <h2 class="mb-0">{{ $customersCount ?? 0 }}</h2>
                        </div>
                        <i class="bi bi-people fs-1"></i>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card text-white bg-warning">
                <div class="card-body">
                    <div class="d-flex justify-content-between align-items-center">
                        <div>
                            <h6 class="card-title">العملات</h6>
                            <h2 class="mb-0">{{ $currenciesCount ?? 0 }}</h2>
                        </div>
                        <i class="bi bi-cash-coin fs-1"></i>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="row">
        <!-- الرسم البياني للمعاملات -->
        <div class="col-md-8">
            <div class="card">
                <div class="card-header">
                    <div class="d-flex justify-content-between align-items-center">
                        <h5 class="mb-0">المعاملات (آخر 7 أيام)</h5>
                        <div class="btn-group" role="group">
                            <button type="button" class="btn btn-sm btn-outline-secondary">يومي</button>
                            <button type="button" class="btn btn-sm btn-outline-secondary active">أسبوعي</button>
                            <button type="button" class="btn btn-sm btn-outline-secondary">شهري</button>
                        </div>
                    </div>
                </div>
                <div class="card-body">
                    <canvas id="transactionsChart" height="300"></canvas>
                </div>
            </div>
        </div>

        <!-- آخر المعاملات -->
        <div class="col-md-4">
            <div class="card">
                <div class="card-header">
                    <h5 class="mb-0">آخر المعاملات</h5>
                </div>
                <div class="card-body p-0">
                    <ul class="list-group list-group-flush">
                        @if(isset($latestTransactions) && count($latestTransactions) > 0)
                            @foreach($latestTransactions as $transaction)
                                <li class="list-group-item">
                                    <div class="d-flex justify-content-between align-items-center">
                                        <div>
                                            <h6 class="mb-0">{{ $transaction->transaction_number }}</h6>
                                            <small class="text-muted">{{ $transaction->created_at->format('Y-m-d H:i') }}</small>
                                        </div>
                                        <span class="badge bg-{{ $transaction->status == 'completed' ? 'success' : 'warning' }}">
                                            {{ $transaction->from_amount }} {{ $transaction->fromCurrency->code }} 
                                            <i class="bi bi-arrow-right"></i> 
                                            {{ $transaction->to_amount }} {{ $transaction->toCurrency->code }}
                                        </span>
                                    </div>
                                </li>
                            @endforeach
                        @else
                            <li class="list-group-item text-center">لا توجد معاملات حديثة</li>
                        @endif
                    </ul>
                </div>
                <div class="card-footer text-center">
                    {{-- <a href="{{ route('transactions.index') }}" class="btn btn-sm btn-primary">عرض جميع المعاملات</a> --}}
                </div>
            </div>
        </div>
    </div>

    <div class="row mt-4">
        <!-- أسعار العملات -->
        <div class="col-md-6">
            <div class="card">
                <div class="card-header">
                    <h5 class="mb-0">أسعار العملات الحالية</h5>
                </div>
                <div class="card-body p-0">
                    <div class="table-responsive">
                        <table class="table table-hover mb-0">
                            <thead>
                                <tr>
                                    <th>العملة</th>
                                    <th>الشراء</th>
                                    <th>البيع</th>
                                    <th>آخر تحديث</th>
                                </tr>
                            </thead>
                            <tbody>
                                @if(isset($exchangeRates) && count($exchangeRates) > 0)
                                    @foreach($exchangeRates as $rate)
                                        <tr>
                                            <td>
                                                <div class="d-flex align-items-center">
                                                    <span class="me-2">{{ $rate->fromCurrency->symbol }}</span>
                                                    <div>
                                                        <h6 class="mb-0">{{ $rate->fromCurrency->code }}</h6>
                                                        <small class="text-muted">{{ $rate->fromCurrency->name }}</small>
                                                    </div>
                                                </div>
                                            </td>
                                            <td>{{ number_format($rate->buy_rate, 4) }}</td>
                                            <td>{{ number_format($rate->sell_rate, 4) }}</td>
                                            <td>{{ $rate->updated_at->format('Y-m-d H:i') }}</td>
                                        </tr>
                                    @endforeach
                                @else
                                    <tr>
                                        <td colspan="4" class="text-center">لا توجد أسعار صرف متاحة</td>
                                    </tr>
                                @endif
                            </tbody>
                        </table>
                    </div>
                </div>
                <div class="card-footer text-center">
                    <a href="{{ route('exchange-rates.index') }}" class="btn btn-sm btn-primary">إدارة أسعار الصرف</a>
                </div>
            </div>
        </div>

        <!-- الحوالات المعلقة -->
        <div class="col-md-6">
            <div class="card">
                <div class="card-header">
                    <h5 class="mb-0">الحوالات المعلقة</h5>
                </div>
                <div class="card-body p-0">
                    <div class="table-responsive">
                        <table class="table table-hover mb-0">
                            <thead>
                                <tr>
                                    <th>رقم الحوالة</th>
                                    <th>المرسل</th>
                                    <th>المستلم</th>
                                    <th>المبلغ</th>
                                    <th>الحالة</th>
                                </tr>
                            </thead>
                            <tbody>
                                @if(isset($pendingRemittances) && count($pendingRemittances) > 0)
                                    @foreach($pendingRemittances as $remittance)
                                        <tr>
                                            <td>{{ $remittance->remittance_number }}</td>
                                            <td>{{ $remittance->sender->name }}</td>
                                            <td>{{ $remittance->receiver_name }}</td>
                                            <td>
                                                {{ number_format($remittance->to_amount, 2) }} 
                                                {{ $remittance->toCurrency->code }}
                                            </td>
                                            <td>
                                                <span class="badge bg-warning">معلقة</span>
                                            </td>
                                        </tr>
                                    @endforeach
                                @else
                                    <tr>
                                        <td colspan="5" class="text-center">لا توجد حوالات معلقة</td>
                                    </tr>
                                @endif
                            </tbody>
                        </table>
                    </div>
                </div>
                <div class="card-footer text-center">
                    <a href="{{ route('remittances.index') }}" class="btn btn-sm btn-primary">إدارة الحوالات</a>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@section('scripts')
<script>
    // رسم بياني للمعاملات
    const ctx = document.getElementById('transactionsChart').getContext('2d');
    const transactionsChart = new Chart(ctx, {
        type: 'line',
        data: {
            labels: ['الأحد', 'الإثنين', 'الثلاثاء', 'الأربعاء', 'الخميس', 'الجمعة', 'السبت'],
            datasets: [{
                label: 'المعاملات',
                data: [12, 19, 3, 5, 2, 3, 7],
                borderColor: '#3490dc',
                backgroundColor: 'rgba(52, 144, 220, 0.1)',
                borderWidth: 2,
                tension: 0.3,
                fill: true
            }, {
                label: 'الحوالات',
                data: [5, 10, 2, 8, 4, 7, 9],
                borderColor: '#38c172',
                backgroundColor: 'rgba(56, 193, 114, 0.1)',
                borderWidth: 2,
                tension: 0.3,
                fill: true
            }]
        },
        options: {
            responsive: true,
            plugins: {
                legend: {
                    position: 'top',
                }
            },
            scales: {
                y: {
                    beginAtZero: true
                }
            }
        }
    });
</script>
@endsection
