@extends('layouts.app')

@section('title', 'إدارة العملات')

@section('content')
<div class="container-fluid">
    <div class="card">
        <div class="card-header d-flex justify-content-between align-items-center">
            <h5 class="mb-0">قائمة العملات</h5>
            <button type="button" class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#addCurrencyModal">
                <i class="bi bi-plus-lg"></i> إضافة عملة جديدة
            </button>
        </div>
        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-hover">
                    <thead>
                        <tr>
                            <th>#</th>
                            <th>الرمز</th>
                            <th>الاسم</th>
                            <th>الرمز المختصر</th>
                            <th>العملة الأساسية</th>
                            <th>الحالة</th>
                            <th>الإجراءات</th>
                        </tr>
                    </thead>
                    <tbody>
                        @if(isset($currencies) && count($currencies) > 0)
                            @foreach($currencies as $currency)
                                <tr>
                                    <td>{{ $loop->iteration }}</td>
                                    <td>{{ $currency->code }}</td>
                                    <td>{{ $currency->name }}</td>
                                    <td>{{ $currency->symbol }}</td>
                                    <td>
                                        @if($currency->is_base_currency)
                                            <span class="badge bg-success">نعم</span>
                                        @else
                                            <span class="badge bg-secondary">لا</span>
                                        @endif
                                    </td>
                                    <td>
                                        @if($currency->is_active)
                                            <span class="badge bg-success">نشط</span>
                                        @else
                                            <span class="badge bg-danger">غير نشط</span>
                                        @endif
                                    </td>
                                    <td>
                                        <div class="btn-group" role="group">
                                            <button type="button" class="btn btn-sm btn-info" data-bs-toggle="modal" data-bs-target="#editCurrencyModal{{ $currency->id }}">
                                                <i class="bi bi-pencil"></i>
                                            </button>
                                            <button type="button" class="btn btn-sm btn-danger" data-bs-toggle="modal" data-bs-target="#deleteCurrencyModal{{ $currency->id }}">
                                                <i class="bi bi-trash"></i>
                                            </button>
                                        </div>
                                    </td>
                                </tr>
                            @endforeach
                        @else
                            <tr>
                                <td colspan="7" class="text-center">لا توجد عملات مسجلة</td>
                            </tr>
                        @endif
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>

<!-- نافذة إضافة عملة جديدة -->
<div class="modal fade" id="addCurrencyModal" tabindex="-1" aria-labelledby="addCurrencyModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <form action="{{ route('currencies.store') }}" method="POST">
                @csrf
                <div class="modal-header">
                    <h5 class="modal-title" id="addCurrencyModalLabel">إضافة عملة جديدة</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="إغلاق"></button>
                </div>
                <div class="modal-body">
                    <div class="mb-3">
                        <label for="code" class="form-label">رمز العملة <span class="text-danger">*</span></label>
                        <input type="text" class="form-control" id="code" name="code" required maxlength="3" placeholder="مثال: USD">
                        <div class="form-text">يجب أن يكون الرمز 3 أحرف فقط</div>
                    </div>
                    <div class="mb-3">
                        <label for="name" class="form-label">اسم العملة <span class="text-danger">*</span></label>
                        <input type="text" class="form-control" id="name" name="name" required placeholder="مثال: دولار أمريكي">
                    </div>
                    <div class="mb-3">
                        <label for="symbol" class="form-label">الرمز المختصر</label>
                        <input type="text" class="form-control" id="symbol" name="symbol" placeholder="مثال: $">
                    </div>
                    <div class="mb-3 form-check">
                        <input type="checkbox" class="form-check-input" id="is_base_currency" name="is_base_currency">
                        <label class="form-check-label" for="is_base_currency">العملة الأساسية للنظام</label>
                    </div>
                    <div class="mb-3 form-check">
                        <input type="checkbox" class="form-check-input" id="is_active" name="is_active" checked>
                        <label class="form-check-label" for="is_active">نشط</label>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">إلغاء</button>
                    <button type="submit" class="btn btn-primary">حفظ</button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- نوافذ تعديل وحذف العملات (ستتم إضافتها ديناميكيًا لكل عملة) -->
@if(isset($currencies))
    @foreach($currencies as $currency)
        <!-- نافذة تعديل العملة -->
        <div class="modal fade" id="editCurrencyModal{{ $currency->id }}" tabindex="-1" aria-labelledby="editCurrencyModalLabel{{ $currency->id }}" aria-hidden="true">
            <div class="modal-dialog">
                <div class="modal-content">
                    <form action="{{ route('currencies.update', $currency->id) }}" method="POST">
                        @csrf
                        @method('PUT')
                        <div class="modal-header">
                            <h5 class="modal-title" id="editCurrencyModalLabel{{ $currency->id }}">تعديل العملة</h5>
                            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="إغلاق"></button>
                        </div>
                        <div class="modal-body">
                            <div class="mb-3">
                                <label for="edit_code{{ $currency->id }}" class="form-label">رمز العملة <span class="text-danger">*</span></label>
                                <input type="text" class="form-control" id="edit_code{{ $currency->id }}" name="code" required maxlength="3" value="{{ $currency->code }}">
                            </div>
                            <div class="mb-3">
                                <label for="edit_name{{ $currency->id }}" class="form-label">اسم العملة <span class="text-danger">*</span></label>
                                <input type="text" class="form-control" id="edit_name{{ $currency->id }}" name="name" required value="{{ $currency->name }}">
                            </div>
                            <div class="mb-3">
                                <label for="edit_symbol{{ $currency->id }}" class="form-label">الرمز المختصر</label>
                                <input type="text" class="form-control" id="edit_symbol{{ $currency->id }}" name="symbol" value="{{ $currency->symbol }}">
                            </div>
                            <div class="mb-3 form-check">
                                <input type="checkbox" class="form-check-input" id="edit_is_base_currency{{ $currency->id }}" name="is_base_currency" {{ $currency->is_base_currency ? 'checked' : '' }}>
                                <label class="form-check-label" for="edit_is_base_currency{{ $currency->id }}">العملة الأساسية للنظام</label>
                            </div>
                            <div class="mb-3 form-check">
                                <input type="checkbox" class="form-check-input" id="edit_is_active{{ $currency->id }}" name="is_active" {{ $currency->is_active ? 'checked' : '' }}>
                                <label class="form-check-label" for="edit_is_active{{ $currency->id }}">نشط</label>
                            </div>
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">إلغاء</button>
                            <button type="submit" class="btn btn-primary">حفظ التغييرات</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>

        <!-- نافذة حذف العملة -->
        <div class="modal fade" id="deleteCurrencyModal{{ $currency->id }}" tabindex="-1" aria-labelledby="deleteCurrencyModalLabel{{ $currency->id }}" aria-hidden="true">
            <div class="modal-dialog">
                <div class="modal-content">
                    <form action="{{ route('currencies.destroy', $currency->id) }}" method="POST">
                        @csrf
                        @method('DELETE')
                        <div class="modal-header">
                            <h5 class="modal-title" id="deleteCurrencyModalLabel{{ $currency->id }}">تأكيد الحذف</h5>
                            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="إغلاق"></button>
                        </div>
                        <div class="modal-body">
                            <p>هل أنت متأكد من حذف العملة "{{ $currency->name }} ({{ $currency->code }})"؟</p>
                            <div class="alert alert-warning">
                                <i class="bi bi-exclamation-triangle"></i>
                                تحذير: سيؤدي حذف هذه العملة إلى حذف جميع أسعار الصرف المرتبطة بها.
                            </div>
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">إلغاء</button>
                            <button type="submit" class="btn btn-danger">تأكيد الحذف</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    @endforeach
@endif
@endsection
