<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('accounts', function (Blueprint $table) {
            $table->increments('id');
            $table->string('name', 100);
            $table->enum('account_type', ['cash', 'bank', 'safe', 'virtual']);
            $table->string('account_number', 50)->nullable();
            $table->unsignedInteger('currency_id');
            $table->unsignedInteger('branch_id');
            $table->boolean('is_active')->default(true);
            $table->decimal('opening_balance', 15, 2)->default(0.00);
            $table->decimal('current_balance', 15, 2)->default(0.00);
            $table->unsignedBigInteger('last_transaction_id')->nullable();
            $table->timestamps();
            
            $table->foreign('currency_id')->references('id')->on('currencies')
                  ->onDelete('restrict')->onUpdate('cascade');
            $table->foreign('branch_id')->references('id')->on('branches')
                  ->onDelete('restrict')->onUpdate('cascade');
        });
        
        // إضافة العلاقة العكسية في جدول المعاملات
        Schema::table('transactions', function (Blueprint $table) {
            $table->foreign('account_id')->references('id')->on('accounts')
                  ->onDelete('restrict')->onUpdate('cascade');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('transactions', function (Blueprint $table) {
            $table->dropForeign(['account_id']);
        });
        
        Schema::dropIfExists('accounts');
    }
};
