<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('remittances', function (Blueprint $table) {
            $table->id();
            $table->string('reference_number', 20)->unique();
            $table->string('sender_name', 100);
            $table->string('sender_phone', 20)->nullable();
            $table->text('sender_address')->nullable();
            $table->string('sender_id_type', 50)->nullable();
            $table->string('sender_id_number', 50)->nullable();
            $table->string('recipient_name', 100);
            $table->string('recipient_phone', 20)->nullable();
            $table->text('recipient_address')->nullable();
            $table->decimal('amount', 15, 2);
            $table->decimal('fee', 10, 2)->default(0.00);
            $table->decimal('total_amount', 15, 2);
            $table->unsignedInteger('currency_id');
            $table->decimal('exchange_rate', 15, 6)->nullable();
            $table->decimal('destination_amount', 15, 2)->nullable();
            $table->unsignedInteger('destination_currency_id')->nullable();
            $table->unsignedInteger('source_agent_id')->nullable();
            $table->unsignedInteger('destination_agent_id')->nullable();
            $table->enum('status', ['pending', 'completed', 'cancelled', 'refunded'])->default('pending');
            $table->string('payment_method', 50)->nullable();
            $table->text('purpose')->nullable();
            $table->text('notes')->nullable();
            $table->unsignedInteger('branch_id');
            $table->unsignedBigInteger('user_id');
            $table->timestamps();
            $table->dateTime('completed_at')->nullable();
            
            $table->index('status');
            $table->index('created_at');
            
            $table->foreign('currency_id')->references('id')->on('currencies')
                  ->onDelete('restrict')->onUpdate('cascade');
            $table->foreign('destination_currency_id')->references('id')->on('currencies')
                  ->onDelete('restrict')->onUpdate('cascade');
            $table->foreign('source_agent_id')->references('id')->on('agents')
                  ->onDelete('restrict')->onUpdate('cascade');
            $table->foreign('destination_agent_id')->references('id')->on('agents')
                  ->onDelete('restrict')->onUpdate('cascade');
            $table->foreign('branch_id')->references('id')->on('branches')
                  ->onDelete('restrict')->onUpdate('cascade');
            $table->foreign('user_id')->references('id')->on('users')
                  ->onDelete('restrict')->onUpdate('cascade');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('remittances');
    }
};
