<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('agent_transactions', function (Blueprint $table) {
            $table->id();
            $table->unsignedInteger('agent_id');
            $table->enum('transaction_type', ['remittance', 'exchange', 'deposit', 'withdrawal', 'commission', 'adjustment']);
            $table->decimal('amount', 15, 2);
            $table->unsignedInteger('currency_id');
            $table->unsignedBigInteger('reference_id')->nullable();
            $table->string('reference_type', 50)->nullable();
            $table->text('description')->nullable();
            $table->unsignedBigInteger('user_id');
            $table->unsignedInteger('branch_id');
            $table->timestamp('created_at')->useCurrent();
            
            $table->index(['reference_id', 'reference_type']);
            
            $table->foreign('agent_id')->references('id')->on('agents')
                  ->onDelete('cascade')->onUpdate('cascade');
            $table->foreign('user_id')->references('id')->on('users')
                  ->onDelete('restrict')->onUpdate('cascade');
            $table->foreign('branch_id')->references('id')->on('branches')
                  ->onDelete('restrict')->onUpdate('cascade');
        });
        
        // إضافة العلاقة العكسية في جدول أرصدة الوكلاء
        Schema::table('agent_balances', function (Blueprint $table) {
            $table->foreign('last_transaction_id')->references('id')->on('agent_transactions')
                  ->onDelete('set null')->onUpdate('cascade');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('agent_balances', function (Blueprint $table) {
            $table->dropForeign(['last_transaction_id']);
        });
        
        Schema::dropIfExists('agent_transactions');
    }
};
