<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('agent_balances', function (Blueprint $table) {
            $table->id();
            $table->unsignedInteger('agent_id');
            $table->unsignedInteger('currency_id');
            $table->decimal('balance', 15, 2)->default(0.00);
            $table->unsignedBigInteger('last_transaction_id')->nullable();
            $table->timestamp('updated_at')->useCurrent()->useCurrentOnUpdate();
            
            $table->unique(['agent_id', 'currency_id']);
            
            $table->foreign('agent_id')->references('id')->on('agents')
                  ->onDelete('cascade')->onUpdate('cascade');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('agent_balances');
    }
};
