<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Permission extends Model
{
    use HasFactory;

   /**
     * The attributes that aren't mass assignable.
     *
     * @var array
     */
    protected $guarded = ['id'];

    /**
     * علاقة الصلاحية بالأدوار.
     *
     * @return \Illuminate\Database\Eloquent\Relations\BelongsToMany
     */
    public function roles()
    {
        return $this->belongsToMany(Role::class, 'role_permissions')
                    ->withTimestamps();
    }

    /**
     * الحصول على جميع المستخدمين الذين لديهم هذه الصلاحية.
     *
     * @return \Illuminate\Database\Eloquent\Collection
     */
    public function users()
    {
        return User::whereHas('role', function ($query) {
            $query->whereHas('permissions', function ($query) {
                $query->where('permissions.id', $this->id);
            });
        })->get();
    }
}
