<?php

namespace App\Http\Controllers;

use App\Models\Currency;
use App\Models\Customer;
use App\Models\ExchangeRate;
use App\Models\Remittance;
use App\Models\Transaction;
use Illuminate\Http\Request;

class DashboardController extends Controller
{
    /**
     * عرض لوحة التحكم الرئيسية
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        // إحصائيات سريعة
        $transactionsCount = Transaction::count();
        $remittancesCount = Remittance::count();
        $customersCount = Customer::count();
        $currenciesCount = Currency::count();
        
        // آخر المعاملات
        $latestTransactions = Transaction::with(['fromCurrency', 'toCurrency'])
            ->orderBy('created_at', 'desc')
            ->limit(5)
            ->get();
        
        // أسعار الصرف الحالية
        $exchangeRates = ExchangeRate::with(['fromCurrency', 'toCurrency'])
            ->where('is_active', true)
            ->orderBy('from_currency_id')
            ->get();
        
        // الحوالات المعلقة
        $pendingRemittances = Remittance::with(['sender', 'fromCurrency', 'toCurrency'])
            ->where('status', 'pending')
            ->orderBy('created_at', 'desc')
            ->limit(5)
            ->get();
        
        return view('dashboard.index', compact(
            'transactionsCount', 
            'remittancesCount', 
            'customersCount', 
            'currenciesCount',
            'latestTransactions',
            'exchangeRates',
            'pendingRemittances'
        ));
    }
}
